/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Rule;
import org.junit.Test;

public class TestRegisteredGenericReturnAndParam {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testRegisterGenericRowMapperAnnotationWorks() throws Exception {
        this.testFoodToppingRestrictions(new GyroProvider(), 1);
        this.testFoodToppingRestrictions(new BurritoProvider(), 2);
    }

    private <T, R, P extends FoodProvider<T, R, ? extends Food<T, R>>> void testFoodToppingRestrictions(P provider, int id) {
        Food food = (Food)this.dbRule.getJdbi().onDemand(provider.getDao());
        T topping = provider.getTopping();
        R restriction = provider.getRestriction();
        food.insertTopping(id, topping);
        List toppings = food.getToppings(id, restriction);
        Assertions.assertThat(toppings).hasSize(1);
        Assertions.assertThat(toppings.get((int)0).value).isEqualTo(topping);
    }

    public static class StringToppingMapper
    implements RowMapper<Topping<String>> {
        public Topping<String> map(ResultSet r, StatementContext ctx) throws SQLException {
            return new Topping<String>(r.getString("name"));
        }
    }

    public static class Topping<T> {
        public T value;

        public Topping(T value) {
            this.value = value;
        }
    }

    public static interface Food<T, R> {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertTopping(@Bind(value="id") int var1, @Bind(value="name") T var2);

        public List<Topping<T>> getToppings(int var1, R var2);
    }

    @RegisterRowMapper(value=StringToppingMapper.class)
    public static interface Burrito
    extends Food<String, Integer> {
        @Override
        @SqlQuery(value="select id, name from something where id = :id and :int + 1 > 0")
        public List<Topping<String>> getToppings(@Bind(value="id") int var1, @Bind(value="int") Integer var2);
    }

    @RegisterRowMapper(value=StringToppingMapper.class)
    public static interface Gyro
    extends Food<String, String> {
        @Override
        @SqlQuery(value="select id, name from something where id = :id and char_length(:str) > 5")
        public List<Topping<String>> getToppings(@Bind(value="id") int var1, @Bind(value="str") String var2);
    }

    public class BurritoProvider
    implements FoodProvider<String, Integer, Burrito> {
        @Override
        public Class<Burrito> getDao() {
            return Burrito.class;
        }

        @Override
        public String getTopping() {
            return "hot sauce";
        }

        @Override
        public Integer getRestriction() {
            return 3;
        }
    }

    public class GyroProvider
    implements FoodProvider<String, String, Gyro> {
        @Override
        public Class<Gyro> getDao() {
            return Gyro.class;
        }

        @Override
        public String getTopping() {
            return "yogurt";
        }

        @Override
        public String getRestriction() {
            return "vegetarian";
        }
    }

    public static interface FoodProvider<T, R, DAO extends Food<T, R>> {
        public Class<DAO> getDao();

        public T getTopping();

        public R getRestriction();
    }
}

