/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestReturningQuery {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testWithRegisteredMapper() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.dbRule.getJdbi().useExtension(Spiffy.class, spiffy -> {
            Something s = (Something)spiffy.findById(7).findOnly();
            Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Tim");
        });
    }

    @Test
    public void testWithExplicitMapper() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.dbRule.getJdbi().useExtension(Spiffy2.class, spiffy -> {
            Something s = (Something)spiffy.findByIdWithExplicitMapper(7).findOnly();
            Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Tim");
        });
    }

    public static interface Spiffy2 {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public ResultIterable<Something> findByIdWithExplicitMapper(@Bind(value="id") int var1);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        public ResultIterable<Something> findById(@Bind(value="id") int var1);
    }
}

