/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestReturningQueryResults {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testSingleValue() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.dbRule.getJdbi().useExtension(Spiffy.class, spiffy -> {
            Something s = spiffy.findById(7);
            Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Tim");
        });
    }

    @Test
    public void testIterator() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.handle.execute("insert into something (id, name) values (3, 'Diego')", new Object[0]);
        this.dbRule.getJdbi().useExtension(Spiffy.class, spiffy -> {
            Iterator<Something> itty = spiffy.findByIdRange(2, 10);
            Assertions.assertThat(itty).containsOnlyOnce((Object[])new Something[]{new Something(7, "Tim"), new Something(3, "Diego")});
        });
    }

    @Test
    public void testList() throws Exception {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.handle.execute("insert into something (id, name) values (3, 'Diego')", new Object[0]);
        this.dbRule.getJdbi().useExtension(Spiffy.class, spiffy -> {
            List<Something> all = spiffy.findTwoByIds(3, 7);
            Assertions.assertThat(all).containsOnlyOnce((Object[])new Something[]{new Something(7, "Tim"), new Something(3, "Diego")});
        });
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something findById(@Bind(value="id") int var1);

        @SqlQuery(value="select id, name from something where id >= :from and id <= :to")
        @UseRowMapper(value=SomethingMapper.class)
        public Iterator<Something> findByIdRange(@Bind(value="from") int var1, @Bind(value="to") int var2);

        @SqlQuery(value="select id, name from something where id = :first or id = :second")
        @UseRowMapper(value=SomethingMapper.class)
        public List<Something> findTwoByIds(@Bind(value="first") int var1, @Bind(value="second") int var2);
    }
}

