/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestSqlMethodAnnotations {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testMutuallyExclusiveAnnotations() {
        Assertions.assertThatThrownBy(() -> {
            Broken cfr_ignored_0 = (Broken)this.handle.attach(Broken.class);
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testCustomAnnotation() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Assertions.assertThat((String)dao.foo()).isEqualTo((Object)"foo");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlOperation(value=Impl.class)
    public static @interface Foo {

        public static class Impl
        implements Handler {
            public Object invoke(Object target, Object[] args, HandleSupplier handle) throws Exception {
                return "foo";
            }
        }
    }

    public static interface Dao {
        @Foo
        public String foo();
    }

    public static interface Broken {
        @SqlQuery
        @SqlUpdate
        public void bogus();
    }
}

