/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.DecoratorOrder;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.HandlerDecorators;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlOperation;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSqlMethodDecorators {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Handle handle;
    private static final ThreadLocal<List<String>> INVOCATIONS = ThreadLocal.withInitial(ArrayList::new);

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
        INVOCATIONS.get().clear();
    }

    @Test
    public void testUnordered() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.unordered();
        Assertions.assertThat(INVOCATIONS.get()).isIn(new Object[]{Arrays.asList("foo", "bar", "method"), Arrays.asList("bar", "foo", "method")});
    }

    @Test
    public void testOrderedFooBar() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.orderedFooBar();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    @Test
    public void testOrderedBarFoo() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.orderedBarFoo();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"bar", "foo", "method"});
    }

    @Test
    public void testOrderedFooBarOnType() {
        OrderedOnType dao = (OrderedOnType)this.handle.attach(OrderedOnType.class);
        dao.orderedFooBarOnType();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    @Test
    public void testOrderedFooBarOnTypeOverriddenToBarFooOnMethod() {
        OrderedOnType dao = (OrderedOnType)this.handle.attach(OrderedOnType.class);
        dao.orderedBarFooOnMethod();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"bar", "foo", "method"});
    }

    @Test
    public void testAbortingDecorator() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.abortingDecorator();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "abort"});
    }

    @Test
    public void testRegisteredDecorator() {
        ((HandlerDecorators)this.handle.getConfig(HandlerDecorators.class)).register((base, sqlObjectType, method) -> (obj, args, handle) -> {
            TestSqlMethodDecorators.invoked("custom");
            return base.invoke(obj, args, handle);
        });
        ((Dao)this.handle.attach(Dao.class)).orderedFooBar();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"custom", "foo", "bar", "method"});
    }

    @Test
    public void testRegisteredDecoratorReturnsBase() {
        ((HandlerDecorators)this.handle.getConfig(HandlerDecorators.class)).register((base, sqlObjectType, method) -> base);
        ((Dao)this.handle.attach(Dao.class)).orderedFooBar();
        Assertions.assertThat(INVOCATIONS.get()).containsExactly((Object[])new String[]{"foo", "bar", "method"});
    }

    static void invoked(String value) {
        INVOCATIONS.get().add(value);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlOperation(value=Impl.class)
    public static @interface CustomSqlOperation {

        public static class Impl
        implements Handler {
            public Object invoke(Object target, Object[] args, HandleSupplier handle) throws Exception {
                TestSqlMethodDecorators.invoked("method");
                return null;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlMethodDecoratingAnnotation(value=Factory.class)
    public static @interface Abort {

        public static class Factory
        implements HandlerDecorator {
            public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
                return (obj, args, handle) -> {
                    TestSqlMethodDecorators.invoked("abort");
                    return null;
                };
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlMethodDecoratingAnnotation(value=Factory.class)
    public static @interface Bar {

        public static class Factory
        implements HandlerDecorator {
            public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
                return (obj, args, handle) -> {
                    TestSqlMethodDecorators.invoked("bar");
                    return base.invoke(obj, args, handle);
                };
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @SqlMethodDecoratingAnnotation(value=Factory.class)
    public static @interface Foo {

        public static class Factory
        implements HandlerDecorator {
            public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
                return (obj, args, handle) -> {
                    TestSqlMethodDecorators.invoked("foo");
                    return base.invoke(obj, args, handle);
                };
            }
        }
    }

    @DecoratorOrder(value={Foo.class, Bar.class})
    public static interface OrderedOnType {
        @Foo
        @Bar
        @CustomSqlOperation
        public void orderedFooBarOnType();

        @Foo
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Bar.class, Foo.class})
        public void orderedBarFooOnMethod();
    }

    public static interface Dao {
        @Foo
        @Bar
        @CustomSqlOperation
        public void unordered();

        @Foo
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Foo.class, Bar.class})
        public void orderedFooBar();

        @Foo
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Bar.class, Foo.class})
        public void orderedBarFoo();

        @Foo
        @Abort
        @Bar
        @CustomSqlOperation
        @DecoratorOrder(value={Foo.class, Abort.class, Bar.class})
        public void abortingDecorator();
    }
}

