/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.customizer.MaxRows;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.subpackage.BrokenDao;
import org.jdbi.v3.sqlobject.subpackage.SomethingDao;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSqlObject {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testPassThroughMethod() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.insert(3, "Cora");
        Something c = dao.findByIdHeeHee(3);
        Assertions.assertThat((Object)c).isEqualTo((Object)new Something(3, "Cora"));
    }

    @Test
    public void testUnimplementedMethod() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Method UnimplementedDao.totallyBroken must be default or be annotated with a SQL method annotation.");
        this.handle.attach(UnimplementedDao.class);
    }

    @Test
    public void testRedundantMethodHasDefaultImplementAndAlsoSqlMethodAnnotation() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Default method RedundantDao.list has @SqlQuery annotation. SQL object methods may be default, or have a SQL method annotation, but not both.");
        this.handle.attach(RedundantDao.class);
    }

    @Test
    public void testPassThroughMethodWithDaoInAnotherPackage() throws Exception {
        SomethingDao dao = (SomethingDao)this.handle.attach(SomethingDao.class);
        dao.insert(3, "Cora");
        Something c = dao.findByIdHeeHee(3);
        Assertions.assertThat((Object)c).isEqualTo((Object)new Something(3, "Cora"));
    }

    @Test
    public void testUnimplementedMethodWithDaoInAnotherPackage() throws Exception {
        Assertions.assertThatThrownBy(() -> {
            BrokenDao cfr_ignored_0 = (BrokenDao)this.handle.attach(BrokenDao.class);
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testSimpleTransactionsSucceed() throws Exception {
        SomethingDao dao = (SomethingDao)this.dbRule.getJdbi().onDemand(SomethingDao.class);
        dao.insertInSingleTransaction(10, "Linda");
    }

    @Test
    public void testTransactionAnnotationWorksOnInterfaceDefaultMethod() throws Exception {
        Dao dao = (Dao)this.dbRule.getSharedHandle().attach(Dao.class);
        Assertions.assertThat((boolean)dao.doesTransactionAnnotationWork()).isTrue();
    }

    @Test
    public void testNestedTransactionsCollapseIntoSingleTransaction() {
        Handle handle = (Handle)Mockito.spy((Object)this.dbRule.getSharedHandle());
        Dao dao = (Dao)handle.attach(Dao.class);
        dao.threeNestedTransactions();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)1))).begin();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)1))).commit();
        dao.twoNestedTransactions();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)2))).begin();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)2))).commit();
    }

    @Test
    public void testNestedTransactionWithSameIsolation() {
        Handle handle = (Handle)Mockito.spy((Object)this.dbRule.getSharedHandle());
        Dao dao = (Dao)handle.attach(Dao.class);
        dao.nestedTransactionWithSameIsolation();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)1))).begin();
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)1))).commit();
    }

    @Test
    public void testNestedTransactionWithDifferentIsoltion() {
        Handle handle = (Handle)Mockito.spy((Object)this.dbRule.getSharedHandle());
        Dao dao = (Dao)handle.attach(Dao.class);
        Assertions.assertThatThrownBy(dao::nestedTransactionWithDifferentIsolation).isInstanceOf(TransactionException.class);
    }

    @Test
    public void testSqlUpdateWithTransaction() {
        Handle handle = (Handle)Mockito.spy((Object)this.dbRule.getSharedHandle());
        Dao dao = (Dao)handle.attach(Dao.class);
        dao.insert(1, "foo");
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.never())).begin();
        Assertions.assertThat((Object)dao.findById(1)).isEqualTo((Object)new Something(1, "foo"));
        Assertions.assertThat((Integer)dao.insertTransactional(2, "bar")).isEqualTo(1);
        ((Handle)Mockito.verify((Object)handle, (VerificationMode)Mockito.times((int)1))).begin();
        Assertions.assertThat((Object)dao.findById(2)).isEqualTo((Object)new Something(2, "bar"));
    }

    @Test
    public void testRedundantMethodCustomizingAnnotation() {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Statement customizing annotations don't work on default methods.");
        this.handle.attach(RedundantMethodStatementCustomizingAnnotation.class);
    }

    @Test
    public void testRedundantParameterCustomizingAnnotation() {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Statement customizing annotations don't work on default methods.");
        this.handle.attach(RedundantParameterStatementCustomizingAnnotation.class);
    }

    @Test
    public void testRedundantParameterBindingAnnotation() {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Statement customizing annotations don't work on default methods.");
        this.handle.attach(RedundantParameterBindingAnnotation.class);
    }

    @Test
    public void testBooleanReturn() {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Assertions.assertThat((boolean)dao.insert(1, "a")).isTrue();
        Assertions.assertThat((boolean)dao.update(2, "b")).isFalse();
    }

    @Test
    public void testSubInterfaceOverridesSuperMethods() {
        SubclassDao dao = (SubclassDao)this.handle.attach(SubclassDao.class);
        dao.insert(new Something(1, "foo"));
        Assertions.assertThat((Object)dao.get(1L)).isEqualTo((Object)new Something(1, "foo"));
    }

    @Test
    public void testStaticMethod() {
        this.handle.attach(StaticDao.class);
        Assertions.assertThat((int)StaticDao.staticMethod()).isEqualTo(42);
    }

    public static interface StaticDao
    extends SqlObject {
        public static int staticMethod() {
            return 42;
        }
    }

    public static interface SubclassDao
    extends BaseDao<Something> {
        @Override
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @Override
        @SqlQuery(value="select * from something where id = :id")
        @RegisterBeanMapper(value=Something.class)
        public Something get(long var1);
    }

    public static interface BaseDao<T> {
        public void insert(T var1);

        public T get(long var1);
    }

    public static interface RedundantParameterBindingAnnotation
    extends SqlObject {
        default public String broken(@Bind int wat) {
            return "foo";
        }
    }

    public static interface RedundantParameterStatementCustomizingAnnotation
    extends SqlObject {
        default public List<String> broken(@Define int wut) {
            return Collections.emptyList();
        }
    }

    public static interface RedundantMethodStatementCustomizingAnnotation
    extends SqlObject {
        @MaxRows(value=10)
        default public List<String> broken() {
            return Collections.emptyList();
        }
    }

    public static interface RedundantDao
    extends SqlObject {
        @SqlQuery(value="select * from something")
        @RegisterRowMapper(value=SomethingMapper.class)
        default public List<Something> list() {
            return this.getHandle().createQuery("select * from something").map((RowMapper)new SomethingMapper()).list();
        }
    }

    public static interface UnimplementedDao
    extends SqlObject {
        public void totallyBroken();
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao
    extends SqlObject {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public boolean insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlUpdate(value="update something set name=:name where id=:id")
        public boolean update(int var1, String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @Transaction
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public Integer insertTransactional(@Bind(value="id") int var1, @Bind(value="name") String var2);

        default public Something findByIdHeeHee(int id) {
            return this.findById(id);
        }

        @Transaction
        default public void threeNestedTransactions() {
            this.twoNestedTransactions();
        }

        @Transaction
        default public void twoNestedTransactions() {
            Assertions.assertThat((boolean)this.doesTransactionAnnotationWork()).isTrue();
        }

        @Transaction
        default public boolean doesTransactionAnnotationWork() {
            return this.getHandle().isInTransaction();
        }

        @Transaction(value=TransactionIsolationLevel.READ_UNCOMMITTED)
        default public boolean transactionWithIsolation() {
            return this.getHandle().isInTransaction();
        }

        @Transaction(value=TransactionIsolationLevel.READ_UNCOMMITTED)
        default public void nestedTransactionWithSameIsolation() {
            Assertions.assertThat((boolean)this.transactionWithIsolation()).isTrue();
        }

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        default public void nestedTransactionWithDifferentIsolation() {
            this.transactionWithIsolation();
        }
    }
}

