/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectFactory;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Test;

public class TestSqlObjectFactory {
    private SqlObjectFactory factory = new SqlObjectFactory();

    @Test
    public void accepts() {
        Assertions.assertThat((boolean)this.factory.accepts(NotASqlObject.class)).isFalse();
        Assertions.assertThatThrownBy(() -> this.factory.accepts(SqlObjectClass.class)).hasMessageContaining("only supported for interfaces");
        Assertions.assertThat((boolean)this.factory.accepts(HasAnnotatedMethod.class)).isTrue();
        Assertions.assertThat((boolean)this.factory.accepts(ExtendsSqlObject.class)).isTrue();
    }

    public static interface ExtendsSqlObject
    extends SqlObject {
    }

    public static interface HasAnnotatedMethod {
        @SqlQuery(value="select foo from bar")
        public String foo();
    }

    public abstract class SqlObjectClass
    implements SqlObject {
    }

    static interface NonPublicSqlObject
    extends SqlObject {
    }

    abstract class NotASqlObject {
        NotASqlObject() {
        }

        abstract String foo(String var1);
    }
}

