/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectFactory;
import org.junit.Before;
import org.junit.Test;

public class TestSqlObjectMethodBehavior {
    private UselessDao dao;
    private UselessDao anotherDao;

    @Before
    public void setUp() throws Exception {
        HandleSupplier handleSupplier = new HandleSupplier(){

            public ConfigRegistry getConfig() {
                return new ConfigRegistry();
            }

            public Handle getHandle() {
                throw new UnsupportedOperationException();
            }

            public <V> V invokeInContext(ExtensionMethod extensionMethod, ConfigRegistry config, Callable<V> task) throws Exception {
                return task.call();
            }
        };
        SqlObjectFactory factory = new SqlObjectFactory();
        this.dao = (UselessDao)factory.attach(UselessDao.class, handleSupplier);
        this.anotherDao = (UselessDao)factory.attach(UselessDao.class, handleSupplier);
    }

    @Test
    public void testFinalizeDoesntConnect() throws Exception {
        this.dao.finalize();
    }

    @Test
    public void testEquals() throws Exception {
        Assertions.assertThat((Object)this.dao).isEqualTo((Object)this.dao);
        Assertions.assertThat((Object)this.dao).isNotEqualTo((Object)this.anotherDao);
    }

    @Test
    public void testHashCode() throws Exception {
        Assertions.assertThat((int)this.dao.hashCode()).isEqualTo(this.dao.hashCode());
        Assertions.assertThat((int)this.dao.hashCode()).isNotEqualTo(this.anotherDao.hashCode());
    }

    @Test
    public void testToStringDoesntConnect() throws Exception {
        this.dao.toString();
    }

    public static interface UselessDao
    extends SqlObject {
        public void finalize();
    }
}

