/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Rule;
import org.junit.Test;

public class TestStatements {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testInsert() throws Exception {
        this.dbRule.getJdbi().useExtension(Inserter.class, i -> {
            int rowsAffected = i.insert(2L, "Diego");
            String name = (String)this.dbRule.getSharedHandle().createQuery("select name from something where id = 2").mapTo(String.class).findOnly();
            Assertions.assertThat((int)rowsAffected).isEqualTo(1);
            Assertions.assertThat((String)name).isEqualTo((Object)"Diego");
        });
    }

    @Test
    public void testInsertWithVoidReturn() throws Exception {
        this.dbRule.getJdbi().useExtension(Inserter.class, i -> {
            i.insertWithVoidReturn(2L, "Diego");
            String name = (String)this.dbRule.getSharedHandle().createQuery("select name from something where id = 2").mapTo(String.class).findOnly();
            Assertions.assertThat((String)name).isEqualTo((Object)"Diego");
        });
    }

    @Test
    public void testDoubleArgumentBind() throws Exception {
        this.dbRule.getJdbi().useExtension(Doubler.class, d -> Assertions.assertThat((boolean)d.doubleTest("wooooot")).isTrue());
    }

    public static interface Doubler {
        @SqlQuery(value="select :test = :test")
        public boolean doubleTest(@Bind(value="test") String var1);
    }

    public static interface Inserter {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertWithVoidReturn(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

