/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.TimingCollector;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Timestamped;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.JdbiRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestTimestamped {
    public PersonDAO personDAO;
    @Rule
    public JdbiRule dbRule = JdbiRule.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Before
    public void before() {
        this.personDAO = (PersonDAO)this.dbRule.getJdbi().onDemand(PersonDAO.class);
        this.personDAO.createTable();
    }

    @Test
    public void shouldInsertCreatedAndModifiedFields() {
        this.dbRule.getJdbi().setTimingCollector((elapsed, ctx) -> {
            OptionalAssert cfr_ignored_0 = (OptionalAssert)Assertions.assertThat((Optional)ctx.getBinding().findForName("now", ctx)).isPresent();
        });
        Person p = new Person("John", "Phiri");
        p.setId(1);
        this.personDAO.insert(p);
        this.dbRule.getJdbi().setTimingCollector(TimingCollector.NOP_TIMING_COLLECTOR);
        Person found = this.personDAO.get(1);
        Assertions.assertThat((Date)found.getCreated()).isNotNull();
        Assertions.assertThat((Date)found.getModified()).isNotNull();
    }

    @Test
    public void shouldAllowCustomTimestampParameter() {
        LocalDateTime timeBefore = LocalDateTime.now().minusMinutes(1L);
        Person p = new Person("John", "Phiri");
        p.setId(1);
        this.dbRule.getJdbi().setTimingCollector((elapsed, ctx) -> {
            OptionalAssert cfr_ignored_0 = (OptionalAssert)Assertions.assertThat((Optional)ctx.getBinding().findForName("createdAt", ctx)).isPresent();
        });
        this.personDAO.insertWithCustomTimestampFields(p);
        this.dbRule.getJdbi().setTimingCollector(TimingCollector.NOP_TIMING_COLLECTOR);
        Person fetched = this.personDAO.get(1);
        Assertions.assertThat((String)p.getFirstName()).isEqualTo((Object)fetched.getFirstName());
        Assertions.assertThat((String)p.getLastName()).isEqualTo((Object)fetched.getLastName());
        Assertions.assertThat((Date)fetched.getCreated()).isNotNull();
        Assertions.assertThat((Date)fetched.getModified()).isNotNull();
        Assertions.assertThat((Date)fetched.getCreated()).isEqualTo((Object)fetched.getModified());
        Assertions.assertThat((LocalDateTime)timeBefore).isBefore(fetched.getCreated().toLocalDateTime());
    }

    @Test
    public void shouldUpdateModifiedTimestamp() {
        Person p = new Person("John", "Phiri");
        p.setId(3);
        this.dbRule.getJdbi().setTimingCollector((elapsed, ctx) -> {
            OptionalAssert cfr_ignored_0 = (OptionalAssert)Assertions.assertThat((Optional)ctx.getBinding().findForName("now", ctx)).isPresent();
        });
        this.personDAO.insert(p);
        this.dbRule.getJdbi().setTimingCollector(TimingCollector.NOP_TIMING_COLLECTOR);
        Person personAfterCreate = this.personDAO.get(3);
        personAfterCreate.setLastName("Banda");
        this.personDAO.updatePerson(personAfterCreate);
        Person personAfterUpdate = this.personDAO.get(3);
        Assertions.assertThat((String)personAfterUpdate.getLastName()).isEqualToIgnoringCase((CharSequence)"Banda");
        Assertions.assertThat((Date)personAfterUpdate.getCreated()).isEqualTo((Object)personAfterCreate.getCreated());
        Assertions.assertThat((Date)personAfterUpdate.getModified()).isAfter((Date)personAfterCreate.getModified());
    }

    public static final class Person {
        private int id;
        private String firstName;
        private String lastName;
        private Timestamp created;
        private Timestamp modified;

        public Person(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public Timestamp getCreated() {
            return this.created;
        }

        public void setCreated(Timestamp created) {
            this.created = created;
        }

        public Timestamp getModified() {
            return this.modified;
        }

        public void setModified(Timestamp modified) {
            this.modified = modified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            if (this.id != person.id) {
                return false;
            }
            if (!this.firstName.equals(person.firstName)) {
                return false;
            }
            return this.lastName != null ? this.lastName.equals(person.lastName) : person.lastName == null;
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + this.firstName.hashCode();
            result = 31 * result + this.lastName.hashCode();
            result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
            result = 31 * result + (this.modified != null ? this.modified.hashCode() : 0);
            return result;
        }
    }

    public static final class PersonRowMapper
    implements RowMapper<Person> {
        public Person map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
            Person person = new Person(resultSet.getString("firstName"), resultSet.getString("lastName"));
            person.setId(resultSet.getInt("id"));
            person.setCreated(resultSet.getTimestamp("created"));
            person.setModified(resultSet.getTimestamp("modified"));
            return person;
        }
    }

    @RegisterRowMapper(value=PersonRowMapper.class)
    public static interface PersonDAO {
        @SqlUpdate(value="CREATE TABLE people(id identity primary key, firstName varchar(50), lastName varchar(50), created timestamp, modified timestamp);")
        public void createTable();

        @GetGeneratedKeys
        @SqlUpdate(value="INSERT INTO people(id, firstName, lastName, created, modified) VALUES (:p.id, :p.firstName, :p.lastName, :now, :now)")
        @Timestamped
        public int insert(@BindBean(value="p") Person var1);

        @SqlUpdate(value="INSERT INTO people(id, firstName, lastName, created, modified) VALUES (:p.id, :p.firstName, :p.lastName, :createdAt, :createdAt)")
        @Timestamped(value="createdAt")
        public int insertWithCustomTimestampFields(@BindBean(value="p") Person var1);

        @SqlUpdate(value="UPDATE people SET firstName = :p.firstName, lastName = :p.lastName, modified = :now WHERE id = :p.id")
        @Timestamped
        public int updatePerson(@BindBean(value="p") Person var1);

        @SqlQuery(value="SELECT id, firstName, lastName, created, modified from people WHERE id=:id")
        public Person get(@Bind(value="id") int var1);
    }
}

