/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.transaction.TransactionIsolationLevel;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestTransactionAnnotation {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
    }

    @Test
    public void testTx() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        Something s = dao.insertAndFetch(1, "Ian");
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Ian"));
    }

    @Test
    public void testTxFail() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        this.exception.expectMessage("woof");
        try {
            dao.failed(1, "Ian");
        }
        finally {
            Assertions.assertThat((Object)dao.findById(1)).isNull();
        }
    }

    @Test
    public void testTxActuallyCommits() throws Exception {
        Handle h2 = this.dbRule.openHandle();
        Dao one = (Dao)this.handle.attach(Dao.class);
        Dao two = (Dao)h2.attach(Dao.class);
        Something inserted = one.insertAndFetch(1, "Brian");
        Something fetched = two.findById(1);
        Assertions.assertThat((Object)fetched).isEqualTo((Object)inserted);
    }

    @Test
    public void testConcurrent() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(3);
        CountDownLatch inserted = new CountDownLatch(1);
        CountDownLatch committed = new CountDownLatch(1);
        Other o = (Other)this.dbRule.getJdbi().onDemand(Other.class);
        Future<Void> rf = es.submit(() -> {
            try {
                o.insert(inserted, 1, "diwaker");
                committed.countDown();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
                return null;
            }
        });
        Future<Void> tf = es.submit(() -> {
            try {
                inserted.await();
                committed.await();
                Something s2 = o.find(1);
                Assertions.assertThat((Object)s2).isEqualTo((Object)new Something(1, "diwaker"));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)e.getMessage());
                return null;
            }
        });
        rf.get();
        tf.get();
        es.shutdown();
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Dao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @Transaction(value=TransactionIsolationLevel.READ_COMMITTED)
        default public Something insertAndFetch(int id, String name) {
            this.insert(id, name);
            return this.findById(id);
        }

        @Transaction
        default public Something failed(int id, String name) throws IOException {
            this.insert(id, name);
            throw new IOException("woof");
        }
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Other {
        @Transaction
        default public void insert(CountDownLatch inserted, int id, String name) throws InterruptedException {
            this.reallyInsert(id, name);
            inserted.countDown();
        }

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void reallyInsert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something find(@Bind(value="id") int var1);
    }
}

