/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestUseClasspathSqlLocator {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.getSharedHandle();
        this.handle.execute("insert into something (id, name) values (6, 'Martin')", new Object[0]);
    }

    @Test
    public void testBam() throws Exception {
        Something s = ((Cromulence)this.handle.attach(Cromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Martin");
    }

    @Test
    public void testOverride() throws Exception {
        Something s = ((SubCromulence)this.handle.attach(SubCromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"overridden");
    }

    @Test
    public void testCachedOverride() throws Exception {
        Something s = ((Cromulence)this.handle.attach(Cromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Martin");
        s = ((SubCromulence)this.handle.attach(SubCromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"overridden");
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    @UseClasspathSqlLocator
    public static interface SubCromulence
    extends Cromulence {
    }

    @UseClasspathSqlLocator
    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Cromulence {
        @SqlQuery
        public Something findById(@Bind(value="id") Long var1);
    }
}

