/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.rule.DatabaseRule;
import org.jdbi.v3.core.rule.SqliteDatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.DefinedAttributeTemplateEngine;
import org.jdbi.v3.core.statement.MessageFormatTemplateEngine;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.UseTemplateEngine;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestUseTemplateEngine {
    @Rule
    public DatabaseRule db = new SqliteDatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;

    @Before
    public void before() {
        this.jdbi = (Jdbi)this.db.getJdbi().setTemplateEngine(TemplateEngine.NOP);
    }

    @Test
    public void testUseMessageFormat() {
        String selected = (String)this.jdbi.withExtension(QueriesForMessageFormatTE.class, q -> q.select("foo"));
        Assertions.assertThat((String)selected).isEqualTo((Object)"foo");
    }

    @Test
    public void testUseDefinedAttributes() {
        String selected = (String)this.jdbi.withExtension(QueriesForDefinedAttributeTE.class, q -> q.select("foo"));
        Assertions.assertThat((String)selected).isEqualTo((Object)"foo");
    }

    public static interface QueriesForDefinedAttributeTE {
        @UseTemplateEngine(value=DefinedAttributeTemplateEngine.class)
        @SqlQuery(value="select * from (values(\\'<v>\\'))")
        public String select(@Define(value="v") String var1);
    }

    public static interface QueriesForMessageFormatTE {
        @UseTemplateEngine(value=MessageFormatTemplateEngine.class)
        @SqlQuery(value="select * from (values(''{0}''))")
        public String select(@Define(value="0") String var1);
    }
}

