/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.BindSomething;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestVariousOddities {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testAttach() throws Exception {
        Spiffy s = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        s.insert(new Something(14, "Tom"));
        Something tom = s.byId(14L);
        Assertions.assertThat((String)tom.getName()).isEqualTo((Object)"Tom");
    }

    @Test
    public void testEquals() {
        Spiffy s1 = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Spiffy s2 = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Assertions.assertThat((Object)s1).isEqualTo((Object)s1);
        Assertions.assertThat((Object)s1).isNotSameAs((Object)s2);
        Assertions.assertThat((Object)s1).isNotEqualTo((Object)s2);
    }

    @Test
    public void testToString() {
        Spiffy s1 = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Spiffy s2 = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Assertions.assertThat((String)s1.toString()).isNotNull();
        Assertions.assertThat((String)s2.toString()).isNotNull();
        Assertions.assertThat((String)s1.toString()).isNotEqualTo((Object)s2.toString());
    }

    @Test
    public void testHashCode() {
        Spiffy s1 = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Spiffy s2 = (Spiffy)this.dbRule.getSharedHandle().attach(Spiffy.class);
        Assertions.assertThat((int)s1.hashCode()).isNotZero();
        Assertions.assertThat((int)s2.hashCode()).isNotZero();
        Assertions.assertThat((int)s1.hashCode()).isNotEqualTo(s2.hashCode());
    }

    @Test
    public void testConcurrentHashCode() throws ExecutionException, InterruptedException {
        Callable<SpiffyConcurrent> callable = () -> (SpiffyConcurrent)this.dbRule.getSharedHandle().attach(SpiffyConcurrent.class);
        ExecutorService pool = Executors.newFixedThreadPool(2);
        Future<SpiffyConcurrent> f1 = pool.submit(callable);
        Future<SpiffyConcurrent> f2 = pool.submit(callable);
        pool.shutdown();
        SpiffyConcurrent s1 = f1.get();
        SpiffyConcurrent s2 = f2.get();
        Assertions.assertThat((int)s1.hashCode()).isNotZero();
        Assertions.assertThat((int)s2.hashCode()).isNotZero();
        Assertions.assertThat((int)s1.hashCode()).isNotEqualTo(s2.hashCode());
    }

    @Test
    public void testNullQueryReturn() {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Method org.jdbi.v3.sqlobject.TestVariousOddities$SpiffyBoom#returnNothing is annotated as if it should return a value, but the method is void.");
        this.dbRule.getSharedHandle().attach(SpiffyBoom.class);
    }

    public static interface SpiffyConcurrent
    extends SqlObject {
    }

    public static interface SpiffyBoom {
        @SqlQuery(value="SELECT 1")
        public void returnNothing();
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into something (id, name) values (:it.id, :it.name)")
        public void insert(@BindSomething(value="it") Something var1);
    }
}

