/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.LongValue;
import org.jdbi.v3.sqlobject.config.LongValueColumnMapperFactory;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapperFactories;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapperFactory;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.StringValue;
import org.jdbi.v3.sqlobject.config.StringValueColumnMapperFactory;
import org.jdbi.v3.sqlobject.config.ValueTypeEntity;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestRegisterColumnMapperFactory {
    @Rule
    public H2DatabaseRule rule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle handle;

    @Before
    public void setUp() {
        this.handle = this.rule.getSharedHandle();
        this.handle.execute("create table column_mappers (string_value varchar, long_value integer)", new Object[0]);
        this.handle.execute("insert into column_mappers (string_value, long_value) values (?, ?)", new Object[]{"foo", 1L});
        this.handle.execute("insert into column_mappers (string_value, long_value) values (?, ?)", new Object[]{"bar", 2L});
    }

    @Test
    public void registerColumnMapperFactories() {
        TestDao dao = (TestDao)this.handle.attach(TestDao.class);
        Assertions.assertThat(dao.listStringValues()).containsExactly((Object[])new StringValue[]{StringValue.of("foo"), StringValue.of("bar")});
        Assertions.assertThat(dao.listLongValues()).containsExactly((Object[])new LongValue[]{LongValue.of(1L), LongValue.of(2L)});
        Assertions.assertThat(dao.list()).containsExactly((Object[])new ValueTypeEntity[]{new ValueTypeEntity(StringValue.of("foo"), LongValue.of(1L)), new ValueTypeEntity(StringValue.of("bar"), LongValue.of(2L))});
    }

    public static interface TestDao {
        @SqlQuery(value="select string_value from column_mappers")
        @RegisterColumnMapperFactory(value=StringValueColumnMapperFactory.class)
        public List<StringValue> listStringValues();

        @SqlQuery(value="select long_value from column_mappers")
        @RegisterColumnMapperFactory(value=LongValueColumnMapperFactory.class)
        public List<LongValue> listLongValues();

        @SqlQuery(value="select * from column_mappers")
        @RegisterColumnMapperFactories(value={@RegisterColumnMapperFactory(value=StringValueColumnMapperFactory.class), @RegisterColumnMapperFactory(value=LongValueColumnMapperFactory.class)})
        @RegisterConstructorMapper(value=ValueTypeEntity.class)
        public List<ValueTypeEntity> list();
    }
}

