/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.LongValue;
import org.jdbi.v3.sqlobject.config.RegisterObjectArgumentFactories;
import org.jdbi.v3.sqlobject.config.RegisterObjectArgumentFactory;
import org.jdbi.v3.sqlobject.config.StringValue;
import org.jdbi.v3.sqlobject.config.ValueTypeEntity;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestRegisterObjectArgumentFactory {
    @Rule
    public H2DatabaseRule rule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle handle;

    @Before
    public void setUp() {
        this.handle = this.rule.getSharedHandle();
        this.handle.execute("create table serialized_types (string_value other, long_value other)", new Object[0]);
    }

    @Test
    public void registerFactory() {
        TestDao dao = (TestDao)this.handle.attach(TestDao.class);
        dao.insertStringValue(StringValue.of("foo"));
        dao.insertStringValue(StringValue.of("bar"));
        List values = this.handle.select("select string_value from serialized_types", new Object[0]).map((rs, ctx) -> (StringValue)rs.getObject("string_value")).list();
        Assertions.assertThat((List)values).containsExactly((Object[])new StringValue[]{StringValue.of("foo"), StringValue.of("bar")});
    }

    @Test
    public void registerFactories() {
        TestDao dao = (TestDao)this.handle.attach(TestDao.class);
        dao.insertValues(StringValue.of("foo"), LongValue.of(10L));
        dao.insertValues(StringValue.of("bar"), LongValue.of(20L));
        List values = this.handle.select("select * from serialized_types", new Object[0]).map((rs, ctx) -> ValueTypeEntity.of((StringValue)rs.getObject("string_value"), (LongValue)rs.getObject("long_value"))).list();
        Assertions.assertThat((List)values).containsExactly((Object[])new ValueTypeEntity[]{ValueTypeEntity.of(StringValue.of("foo"), LongValue.of(10L)), ValueTypeEntity.of(StringValue.of("bar"), LongValue.of(20L))});
    }

    public static interface TestDao {
        @SqlUpdate(value="insert into serialized_types (string_value) values (?)")
        @RegisterObjectArgumentFactory(value=StringValue.class)
        public void insertStringValue(StringValue var1);

        @SqlUpdate(value="insert into serialized_types (string_value, long_value) values (?, ?)")
        @RegisterObjectArgumentFactories(value={@RegisterObjectArgumentFactory(value=StringValue.class), @RegisterObjectArgumentFactory(value=LongValue.class)})
        public void insertValues(StringValue var1, LongValue var2);
    }
}

