/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.JoinRow;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.LongValue;
import org.jdbi.v3.sqlobject.config.LongValueRowMapper;
import org.jdbi.v3.sqlobject.config.RegisterJoinRowMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMappers;
import org.jdbi.v3.sqlobject.config.StringValue;
import org.jdbi.v3.sqlobject.config.StringValueRowMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestRegisterRowMapper {
    @Rule
    public H2DatabaseRule rule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle handle;

    @Before
    public void setUp() {
        this.handle = this.rule.getSharedHandle();
        this.handle.execute("create table column_mappers (string_value varchar, long_value integer)", new Object[0]);
        this.handle.execute("insert into column_mappers (string_value, long_value) values (?, ?)", new Object[]{"foo", 1L});
        this.handle.execute("insert into column_mappers (string_value, long_value) values (?, ?)", new Object[]{"bar", 2L});
    }

    @Test
    public void registerColumnMappers() {
        TestDao dao = (TestDao)this.handle.attach(TestDao.class);
        Assertions.assertThat(dao.listX()).containsExactly((Object[])new StringValue[]{StringValue.of("foo"), StringValue.of("bar")});
        Assertions.assertThat(dao.listY()).containsExactly((Object[])new LongValue[]{LongValue.of(1L), LongValue.of(2L)});
        List<JoinRow> joinRows = dao.list();
        Assertions.assertThat(joinRows).extracting(row -> (StringValue)row.get(StringValue.class)).containsExactly((Object[])new StringValue[]{StringValue.of("foo"), StringValue.of("bar")});
        Assertions.assertThat(joinRows).extracting(row -> (LongValue)row.get(LongValue.class)).containsExactly((Object[])new LongValue[]{LongValue.of(1L), LongValue.of(2L)});
    }

    public static interface TestDao {
        @SqlQuery(value="select string_value from column_mappers")
        @RegisterRowMapper(value=StringValueRowMapper.class)
        public List<StringValue> listX();

        @SqlQuery(value="select long_value from column_mappers")
        @RegisterRowMapper(value=LongValueRowMapper.class)
        public List<LongValue> listY();

        @SqlQuery(value="select * from column_mappers")
        @RegisterRowMappers(value={@RegisterRowMapper(value=StringValueRowMapper.class), @RegisterRowMapper(value=LongValueRowMapper.class)})
        @RegisterJoinRowMapper(value={StringValue.class, LongValue.class})
        public List<JoinRow> list();
    }
}

