/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.SqlObjects;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.ParameterCustomizerFactory;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestUseConfiguredDefaultParameterCustomizerFactory {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private AtomicInteger invocationCounter = new AtomicInteger(0);

    @Before
    public void setUp() throws Exception {
        Jdbi db = this.dbRule.getJdbi();
        ParameterCustomizerFactory defaultParameterCustomizerFactory = (sqlObjectType, method, param, index, type) -> {
            this.invocationCounter.incrementAndGet();
            return (stmt, arg) -> stmt.bind("mybind" + index, arg);
        };
        db.configure(SqlObjects.class, c -> c.setDefaultParameterCustomizerFactory(defaultParameterCustomizerFactory));
        this.handle = db.open();
    }

    @Test
    public void shouldUseConfiguredSqlParameterCustomizer() {
        SomethingDao h = (SomethingDao)this.handle.attach(SomethingDao.class);
        h.findByNameAndIdNoBindAnnotation(1, "Joy");
        Assertions.assertThat((int)this.invocationCounter.get()).isEqualTo(2);
    }

    @Test
    public void shouldUseSqlParameterCustomizerFromAnnotation() {
        SomethingDao h = (SomethingDao)this.handle.attach(SomethingDao.class);
        h.findByNameAndIdWithBindAnnotation(1, "Joy");
        Assertions.assertThat((int)this.invocationCounter.get()).isEqualTo(0);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface SomethingDao {
        @SqlQuery(value="select id, name from something where name = :mybind1 and id = :mybind0")
        public Something findByNameAndIdNoBindAnnotation(int var1, String var2);

        @SqlQuery(value="select id, name from something where name = :mybind1 and id = :mybind0")
        public Something findByNameAndIdWithBindAnnotation(@Bind(value="mybind0") int var1, @Bind(value="mybind1") String var2);
    }
}

