/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.Handlers;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestUseCustomHandlerFactory {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        Jdbi db = this.dbRule.getJdbi();
        HandlerFactory defaultHandlerFactory = new HandlerFactory(){

            public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
                return this.getImplementation(sqlObjectType, method).map(m -> (target, args, handle) -> m.invoke(null, Stream.concat(Stream.of(target), Stream.of(args)).toArray()));
            }

            private Optional<Method> getImplementation(Class<?> type, Method method) {
                return Stream.of(type.getClasses()).filter(c -> c.getSimpleName().equals("DefaultImpls")).flatMap(c -> Stream.of(c.getMethods()).filter(m -> m.getName().equals(method.getName()))).findAny();
            }
        };
        db.configure(Handlers.class, c -> c.register(defaultHandlerFactory));
        this.handle = db.open();
    }

    @Test
    public void shouldUseConfiguredDefaultHandler() throws Exception {
        SomethingDao h = (SomethingDao)this.handle.attach(SomethingDao.class);
        Something s = h.insertAndFind(new Something(1, "Joy"));
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Joy");
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface SomethingDao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        @Transaction
        public Something insertAndFind(Something var1);

        public static class DefaultImpls {
            private DefaultImpls() {
            }

            public static Something insertAndFind(SomethingDao dao, Something s) {
                dao.insert(s);
                return dao.findById(s.getId());
            }
        }
    }
}

