/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.ColonPrefixSqlParser;
import org.jdbi.v3.core.statement.HashPrefixSqlParser;
import org.jdbi.v3.core.statement.SqlParser;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.config.UseSqlParser;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestUseSqlParser {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        Jdbi db = this.dbRule.getJdbi();
        db.setSqlParser((SqlParser)new ColonPrefixSqlParser());
        this.handle = db.open();
    }

    @Test
    public void testFoo() throws Exception {
        Hashed h = (Hashed)this.handle.attach(Hashed.class);
        h.insert(new Something(1, "Joy"));
        Something s = h.findById(1);
        Assertions.assertThat((String)s.getName()).isEqualTo((Object)"Joy");
    }

    @UseSqlParser(value=HashPrefixSqlParser.class)
    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Hashed {
        @SqlUpdate(value="insert into something (id, name) values (#id, #name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something where id = #id")
        public Something findById(@Bind(value="id") int var1);
    }
}

