/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.MapMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.MaxRows;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestMaxRows {
    private static final String QUERY = "select bar from foo";
    private static final String CREATE_INSERT = "create table foo(bar int primary key);insert into foo(bar) values(1);insert into foo(bar) values(2);insert into foo(bar) values(3);";
    private static final int ROWS = 1;
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = this.dbRule.openHandle();
    }

    @Test
    public void testMethodWrong() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            FooMethodWrong cfr_ignored_0 = (FooMethodWrong)this.handle.attach(FooMethodWrong.class);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("no value given");
    }

    @Test
    public void testParamWrong() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            FooParamWrong cfr_ignored_0 = (FooParamWrong)this.handle.attach(FooParamWrong.class);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("value won't do anything");
    }

    @Test
    public void testMethodRight() {
        FooMethodRight sqlObject = (FooMethodRight)this.handle.attach(FooMethodRight.class);
        this.handle.createScript(CREATE_INSERT).execute();
        Assertions.assertThat(sqlObject.bar()).hasSize(1);
    }

    @Test
    public void testParamRight() {
        FooParamRight sqlObject = (FooParamRight)this.handle.attach(FooParamRight.class);
        this.handle.createScript(CREATE_INSERT).execute();
        Assertions.assertThat(sqlObject.bar(1)).hasSize(1);
    }

    @Test
    public void testParamNonsense() {
        FooParamRight sqlObject = (FooParamRight)this.handle.attach(FooParamRight.class);
        this.handle.createScript(CREATE_INSERT).execute();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlObject.bar(0)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is 0, which is negative or 0");
    }

    @Test
    public void testMethodNonsense() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            FooMethodNonsenseValue cfr_ignored_0 = (FooMethodNonsenseValue)this.handle.attach(FooMethodNonsenseValue.class);
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is 0, which is negative or 0");
    }

    @Test
    public void testControlGroup() {
        NoMaxRows sqlObject = (NoMaxRows)this.handle.attach(NoMaxRows.class);
        this.handle.createScript(CREATE_INSERT).execute();
        Assertions.assertThat(sqlObject.bar()).hasSize(3);
    }

    public static interface FooMethodNonsenseValue
    extends SqlObject {
        @MaxRows(value=0)
        @SqlQuery(value="select bar from foo")
        @RegisterRowMapper(value=MapMapper.class)
        public List<Map<String, Object>> bar();
    }

    public static interface NoMaxRows
    extends SqlObject {
        @SqlQuery(value="select bar from foo")
        @RegisterRowMapper(value=MapMapper.class)
        public List<Map<String, Object>> bar();
    }

    public static interface FooParamRight
    extends SqlObject {
        @SqlQuery(value="select bar from foo")
        @RegisterRowMapper(value=MapMapper.class)
        public List<Map<String, Object>> bar(@MaxRows int var1);
    }

    public static interface FooMethodRight
    extends SqlObject {
        @MaxRows(value=1)
        @SqlQuery(value="select bar from foo")
        @RegisterRowMapper(value=MapMapper.class)
        public List<Map<String, Object>> bar();
    }

    public static interface FooParamWrong
    extends SqlObject {
        @SqlQuery(value="select bar from foo")
        public List<Map<String, Object>> bar(@MaxRows(value=1) int var1);
    }

    public static interface FooMethodWrong
    extends SqlObject {
        @MaxRows
        @SqlQuery(value="select bar from foo")
        public List<Map<String, Object>> bar();
    }
}

