/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ConfigCustomizerFactory;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionHandler;
import org.jdbi.v3.core.extension.ExtensionHandlerCustomizer;
import org.jdbi.v3.core.extension.ExtensionHandlerFactory;
import org.jdbi.v3.core.extension.ExtensionMetadata;
import org.jdbi.v3.core.internal.JdbiClassUtils;
import org.jdbi.v3.sqlobject.GenerateSqlObject;
import org.jdbi.v3.sqlobject.HandlerDecorators;
import org.jdbi.v3.sqlobject.Handlers;
import org.jdbi.v3.sqlobject.SqlMethodHandlerFactory;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectCustomizerFactory;

abstract class AbstractSqlObjectFactory
implements ExtensionFactory {
    private static final ExtensionHandler WITH_HANDLE_HANDLER = (handleSupplier, target, args) -> ((HandleCallback)args[0]).withHandle(handleSupplier.getHandle());
    private static final ExtensionHandler GET_HANDLE_HANDLER = (handleSupplier, target, args) -> handleSupplier.getHandle();

    AbstractSqlObjectFactory() {
    }

    public void buildExtensionMetadata(ExtensionMetadata.Builder builder) {
        Class extensionType = builder.getExtensionType();
        ExtensionHandler toStringHandler = (handlerSupplier, target, args) -> "Jdbi sqlobject proxy for " + extensionType.getName() + "@" + Integer.toHexString(target.hashCode());
        JdbiClassUtils.safeMethodLookup(Object.class, (String)"toString", (Class[])new Class[0]).ifPresent(m -> builder.addMethodHandler(m, toStringHandler));
        JdbiClassUtils.safeMethodLookup(SqlObject.class, (String)"getHandle", (Class[])new Class[0]).ifPresent(m -> builder.addMethodHandler(m, GET_HANDLE_HANDLER));
        JdbiClassUtils.safeMethodLookup(SqlObject.class, (String)"withHandle", (Class[])new Class[]{HandleCallback.class}).ifPresent(m -> builder.addMethodHandler(m, WITH_HANDLE_HANDLER));
    }

    public Collection<ExtensionHandlerCustomizer> getExtensionHandlerCustomizers(ConfigRegistry config) {
        HandlerDecorators handlerDecorators = (HandlerDecorators)config.get(HandlerDecorators.class);
        return Collections.singleton(handlerDecorators::customize);
    }

    public Collection<ExtensionHandlerFactory> getExtensionHandlerFactories(ConfigRegistry config) {
        Handlers handlers = (Handlers)config.get(Handlers.class);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new SqlMethodHandlerFactory());
        factories.addAll(handlers.getFactories());
        return Collections.unmodifiableList(factories);
    }

    public Collection<ConfigCustomizerFactory> getConfigCustomizerFactories(ConfigRegistry config) {
        return Collections.singleton(SqlObjectCustomizerFactory.FACTORY);
    }

    static boolean isConcrete(Class<?> extensionTypeClass) {
        return extensionTypeClass.getAnnotation(GenerateSqlObject.class) != null;
    }
}

