/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.enums.EnumByName;
import org.jdbi.v3.core.enums.EnumByOrdinal;
import org.jdbi.v3.core.enums.EnumStrategy;
import org.jdbi.v3.core.enums.Enums;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.UseEnumStrategy;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SqlObjectEnumQualifierTest {
    @RegisterExtension
    public JdbiExtension sqliteExtension = JdbiExtension.sqlite().withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void byOrdinalOverridesDefaultInBindingAndMapping() {
        this.sqliteExtension.getJdbi().useHandle(h -> {
            h.execute("create table enums(ordinal int)", new Object[0]);
            FooByOrdinalDao dao = (FooByOrdinalDao)h.attach(FooByOrdinalDao.class);
            dao.insert(Foo.BAR);
            Assertions.assertThat((Integer)((Integer)h.createQuery("select ordinal from enums").mapTo(Integer.class).one())).isZero();
            Foo value = dao.select();
            Assertions.assertThat((Comparable)((Object)value)).isEqualTo((Object)Foo.BAR);
        });
    }

    @Test
    public void byNameOverridesDefaultInBindingAndMapping() {
        this.sqliteExtension.getJdbi().useHandle(h -> {
            ((Enums)h.getConfig(Enums.class)).setEnumStrategy(EnumStrategy.BY_ORDINAL);
            h.execute("create table enums(name varchar)", new Object[0]);
            FooByNameDao dao = (FooByNameDao)h.attach(FooByNameDao.class);
            dao.insert(Foo.BAR);
            Assertions.assertThat((String)((String)h.createQuery("select name from enums").mapTo(String.class).one())).isEqualTo("BAR");
            Foo value = dao.select();
            Assertions.assertThat((Comparable)((Object)value)).isEqualTo((Object)Foo.BAR);
        });
    }

    @Test
    public void useEnumStrategyOrdinalAnnotation() {
        this.sqliteExtension.getJdbi().useHandle(h -> {
            ((Enums)h.getConfig(Enums.class)).setEnumStrategy(EnumStrategy.BY_NAME);
            h.execute("create table enums(ordinal int)", new Object[0]);
            UseEnumStrategyOrdinalDao dao = (UseEnumStrategyOrdinalDao)h.attach(UseEnumStrategyOrdinalDao.class);
            dao.insert(Foo.BAR);
            Assertions.assertThat((Integer)((Integer)h.createQuery("select ordinal from enums").mapTo(Integer.class).one())).isZero();
            Foo value = dao.select();
            Assertions.assertThat((Comparable)((Object)value)).isEqualTo((Object)Foo.BAR);
        });
    }

    @Test
    public void useEnumStrategyNameAnnotation() {
        this.sqliteExtension.getJdbi().useHandle(h -> {
            ((Enums)h.getConfig(Enums.class)).setEnumStrategy(EnumStrategy.BY_ORDINAL);
            h.execute("create table enums(name varchar)", new Object[0]);
            UseEnumStrategyNameDao dao = (UseEnumStrategyNameDao)h.attach(UseEnumStrategyNameDao.class);
            dao.insert(Foo.BAR);
            Assertions.assertThat((String)((String)h.createQuery("select name from enums").mapTo(String.class).one())).isEqualTo("BAR");
            Foo value = dao.select();
            Assertions.assertThat((Comparable)((Object)value)).isEqualTo((Object)Foo.BAR);
        });
    }

    @UseEnumStrategy(value=EnumStrategy.BY_NAME)
    private static interface UseEnumStrategyNameDao {
        @SqlUpdate(value="insert into enums(name) values(:value)")
        public void insert(Foo var1);

        @SqlQuery(value="select name from enums")
        public Foo select();
    }

    public static enum Foo {
        BAR;

    }

    @UseEnumStrategy(value=EnumStrategy.BY_ORDINAL)
    private static interface UseEnumStrategyOrdinalDao {
        @SqlUpdate(value="insert into enums(ordinal) values(:value)")
        public void insert(Foo var1);

        @SqlQuery(value="select ordinal from enums")
        public Foo select();
    }

    private static interface FooByNameDao {
        @SqlUpdate(value="insert into enums(name) values(:value)")
        public void insert(@EnumByName Foo var1);

        @SqlQuery(value="select name from enums")
        @EnumByName
        public Foo select();
    }

    private static interface FooByOrdinalDao {
        @SqlUpdate(value="insert into enums(ordinal) values(:value)")
        public void insert(@EnumByOrdinal Foo var1);

        @SqlQuery(value="select ordinal from enums")
        @EnumByOrdinal
        public Foo select();
    }
}

