/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.RowMappers;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementCustomizers;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class SqlObjectLeakTest {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withInitializer(TestingInitializers.usersWithData()).withConfig(RowMappers.class, r -> r.register(User.class, ConstructorMapper.of(User.class)));

    @Test
    void testManagedHandleExplodingAttachedDao() {
        Assertions.assertThatExceptionOfType(UnableToExecuteStatementException.class).isThrownBy(() -> {
            try (Handle handle = this.h2Extension.openHandle();){
                handle.addCustomizer(StatementCustomizers.fetchSize((int)-1));
                UserDao handleDao = (UserDao)handle.attach(UserDao.class);
                handleDao.getUserNames();
            }
        });
    }

    @Test
    void testExplodingOnDemandDao() {
        Assertions.assertThatExceptionOfType(UnableToExecuteStatementException.class).isThrownBy(() -> {
            Jdbi jdbi = this.h2Extension.getJdbi();
            jdbi.addCustomizer(StatementCustomizers.fetchSize((int)-1));
            UserDao jdbiDao = (UserDao)this.h2Extension.getJdbi().onDemand(UserDao.class);
            jdbiDao.getUserNames();
        });
    }

    @Test
    void testExplodingExtensionDao() {
        Assertions.assertThatExceptionOfType(UnableToExecuteStatementException.class).isThrownBy(() -> {
            Jdbi jdbi = this.h2Extension.getJdbi();
            jdbi.addCustomizer(StatementCustomizers.fetchSize((int)-1));
            jdbi.withExtension(UserDao.class, UserDao::getUserNames);
        });
    }

    public static interface UserDao
    extends SqlObject {
        @SqlQuery(value="SELECT name from users order by id")
        public List<String> getUserNames();
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }
}

