/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.mapper.ImmutableTrain;
import org.jdbi.v3.core.mapper.ImmutablesTest;
import org.jdbi.v3.core.mapper.immutables.JdbiImmutables;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindPojo;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindProperties {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withConfig(JdbiImmutables.class, c -> c.registerImmutable(ImmutablesTest.Train.class));
    private Handle h;
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.h = this.h2Extension.getSharedHandle();
        this.h.execute("create table train (name varchar, carriages int, observation_car boolean)", new Object[0]);
        this.dao = (Dao)this.h.attach(Dao.class);
    }

    @Test
    public void testBindBean() {
        Assertions.assertThat((int)this.dao.insert((ImmutablesTest.Train)ImmutableTrain.builder().name("Zephyr").carriages(8).observationCar(true).build())).isOne();
        Assertions.assertThat((Object)this.dao.getTrains().get(0)).extracting(new String[]{"name", "carriages", "observationCar"}).containsExactly(new Object[]{"Zephyr", 8, true});
    }

    public static interface Dao {
        @SqlUpdate(value="insert into train(name, carriages, observation_car) values (:name, :carriages, :observationCar)")
        public int insert(@BindPojo ImmutablesTest.Train var1);

        @SqlQuery(value="select * from train")
        public List<ImmutablesTest.Train> getTrains();
    }
}

