/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestCollectorFactory {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new GuavaPlugin());

    @Test
    public void testExists() {
        Handle h = this.h2Extension.getSharedHandle();
        h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        Optional rs = ((Query)h.createQuery("select name from something where id = :id").bind("id", 1)).mapTo(String.class).findFirst();
        Assertions.assertThat((Optional)rs).contains((Object)"Coda");
    }

    @Test
    public void testDoesNotExist() {
        Handle h = this.h2Extension.getSharedHandle();
        h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        Optional rs = ((Query)h.createQuery("select name from something where id = :id").bind("id", 2)).mapTo(String.class).findFirst();
        Assertions.assertThat((Optional)rs).isEmpty();
    }

    @Test
    public void testOnList() {
        Handle h = this.h2Extension.getSharedHandle();
        h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        h.execute("insert into something (id, name) values (2, 'Brian')", new Object[0]);
        List rs = (List)h.createQuery("select name from something order by id").mapTo(String.class).collect(Collectors.toList());
        Assertions.assertThat((List)rs).containsExactly((Object[])new String[]{"Coda", "Brian"});
    }

    @Test
    public void testWithSqlObject() {
        Dao dao = (Dao)this.h2Extension.getJdbi().onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        List<String> rs = dao.findAll();
        Assertions.assertThat(rs).containsExactly((Object[])new String[]{"Coda", "Brian"});
    }

    @Test
    public void testWithSqlObjectSingleValue() {
        Dao dao = (Dao)this.h2Extension.getJdbi().onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        Optional<String> rs = dao.findNameById(1);
        Assertions.assertThat(rs).contains((Object)"Coda");
        rs = dao.smartFindNameById(1);
        Assertions.assertThat(rs).contains((Object)"Coda");
        rs = dao.inheritedGenericFindNameById(1);
        Assertions.assertThat(rs).contains((Object)"Coda");
    }

    @Test
    public void testWithSqlObjectSetReturnValue() {
        Dao dao = (Dao)this.h2Extension.getJdbi().onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        SortedSet<String> rs = dao.findAllAsSet();
        Assertions.assertThat(rs).containsExactly((Object[])new String[]{"Brian", "Coda"});
    }

    public static interface Dao
    extends Base<String> {
        @SqlQuery(value="select name from something order by id")
        public List<String> findAll();

        @SqlQuery(value="select name from something order by id")
        public SortedSet<String> findAllAsSet();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public Optional<String> findNameById(@Bind(value="id") int var1);

        @SqlQuery(value="select name from something where id = :id")
        public Optional<String> smartFindNameById(@Bind(value="id") int var1);
    }

    public static interface Base<T> {
        @SqlQuery(value="select name from something where id = :id")
        public Optional<T> inheritedGenericFindNameById(@Bind(value="id") int var1);
    }
}

