/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestConcurrentUpdatingQuery {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.openHandle();
    }

    @AfterEach
    public void tearDown() {
        this.handle.close();
    }

    @Test
    public void testConcurrentUpdateableResultSet() {
        this.handle.execute("create table something (id identity primary key, name varchar(50))", new Object[0]);
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        ((Query)this.handle.createQuery("select id, name from something where id = :id").bind("id", 7)).concurrentUpdatable().map((r, ctx) -> {
            r.updateString("name", "Tom");
            r.updateRow();
            return null;
        }).list();
        String name = (String)((Query)this.handle.createQuery("select name from something where id = :id").bind("id", 7)).mapTo(String.class).one();
        Assertions.assertThat((String)name).isEqualTo("Tom");
    }
}

