/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.ValueType;
import org.jdbi.v3.core.mapper.ValueTypeMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterFieldMapper;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestFieldMapper {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle h;
    TestDao dao;

    @BeforeEach
    public void createTable() {
        this.h = this.h2Extension.openHandle();
        this.h.createUpdate("create table testBean (valueType varchar(50))").execute();
        this.dao = (TestDao)this.h.attach(TestDao.class);
    }

    @AfterEach
    public void tearDown() {
        this.h.close();
    }

    @Test
    public void testMapFields() {
        this.h.createUpdate("insert into testBean (valueType) values ('foo')").execute();
        List<TestObject> beans = this.dao.listBeans();
        Assertions.assertThat(beans).extracting(TestObject::getValueType).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @Test
    public void testMapFieldsPrefix() {
        this.h.createUpdate("insert into testBean (valueType) values ('foo')").execute();
        List<TestObject> beans = this.dao.listBeansPrefix();
        Assertions.assertThat(beans).extracting(TestObject::getValueType).containsExactly((Object[])new ValueType[]{ValueType.valueOf((String)"foo")});
    }

    @RegisterColumnMapper(value=ValueTypeMapper.class)
    public static interface TestDao {
        @SqlQuery(value="select * from testBean")
        @RegisterFieldMapper(value=TestObject.class)
        public List<TestObject> listBeans();

        @SqlQuery(value="select valueType as obj_value_type from testBean")
        @RegisterFieldMapper(value=TestObject.class, prefix="obj_")
        public List<TestObject> listBeansPrefix();
    }

    public static class TestObject {
        ValueType valueType;

        public ValueType getValueType() {
            return this.valueType;
        }
    }
}

