/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestGetGeneratedKeys {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFoo() {
        this.h2Extension.getJdbi().useExtension(DAO.class, dao -> {
            long brianId = dao.insert("Brian");
            long keithId = dao.insert("Keith");
            Assertions.assertThat((String)dao.findNameById(brianId)).isEqualTo("Brian");
            Assertions.assertThat((String)dao.findNameById(keithId)).isEqualTo("Keith");
        });
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (name) values (:name)")
        @GetGeneratedKeys
        public long insert(@Bind(value="name") String var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into something (name) values (:it)")
        @GetGeneratedKeys
        public String generatedKeyReturnType(@Bind String var1);
    }
}

