/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestGetGeneratedKeysHsqlDb {
    private Jdbi db;

    @BeforeEach
    public void setUp() {
        this.db = Jdbi.create((String)("jdbc:hsqldb:mem:" + String.valueOf(UUID.randomUUID())), (String)"username", (String)"password").installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.db.useHandle(handle -> handle.execute("create table something (id identity primary key, name varchar(32))", new Object[0]));
    }

    @Test
    public void testFoo() {
        this.db.useExtension(DAO.class, dao -> {
            long brianId = dao.insert("Brian");
            long keithId = dao.insert("Keith");
            Assertions.assertThat((String)dao.findNameById(brianId)).isEqualTo("Brian");
            Assertions.assertThat((String)dao.findNameById(keithId)).isEqualTo("Keith");
        });
    }

    @Test
    public void testBatch() {
        this.db.useExtension(DAO.class, dao -> {
            int[] ids = dao.insert(Arrays.asList("Burt", "Macklin"));
            Assertions.assertThat((String)dao.findNameById(ids[0])).isEqualTo("Burt");
            Assertions.assertThat((String)dao.findNameById(ids[1])).isEqualTo("Macklin");
        });
    }

    public static interface DAO {
        @SqlUpdate(value="insert into something (name) values (:name)")
        @GetGeneratedKeys
        public long insert(String var1);

        @SqlBatch(value="insert into something (name) values(:names)")
        @GetGeneratedKeys
        public int[] insert(List<String> var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameById(long var1);
    }
}

