/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.CloseException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.transaction.TransactionException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.sqlobject.transaction.Transactional;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class TestOnDemandSqlObject {
    private final HandleTracker tracker = new HandleTracker();
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi jdbi;

    @BeforeEach
    public void setUp() throws Exception {
        this.jdbi = this.h2Extension.getJdbi();
        this.jdbi.installPlugin((JdbiPlugin)this.tracker);
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testAPIWorks() {
        Spiffy s = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        s.insert(7L, "Bill");
        try (Handle handle = this.jdbi.open();){
            String bill = (String)handle.createQuery("select name from something where id = 7").mapTo(String.class).one();
            Assertions.assertThat((String)bill).isEqualTo("Bill");
        }
    }

    @Test
    public void testExceptionOnClose() throws Exception {
        Connection c = (Connection)Mockito.mock(Connection.class, (MockSettings)Mockito.withSettings().defaultAnswer(AdditionalAnswers.delegatesTo((Object)this.h2Extension.getSharedHandle().getConnection())));
        ((Connection)Mockito.doThrow(TransactionException.class).when((Object)c)).prepareStatement((String)ArgumentMatchers.any(), ArgumentMatchers.eq((int)1003), ArgumentMatchers.eq((int)1007));
        ((Connection)Mockito.doThrow(CloseException.class).when((Object)c)).close();
        Spiffy s = (Spiffy)Jdbi.create((Connection)c).installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(Spiffy.class);
        Assertions.assertThatThrownBy(() -> s.insert(1L, "Tom")).isInstanceOf(TransactionException.class);
    }

    @Test
    public void testIteratorCloseHandleOnError() throws Exception {
        Spiffy s = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        Assertions.assertThatExceptionOfType(JdbiException.class).isThrownBy(s::crashNow);
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testIteratorClosedOnReadError() throws Exception {
        Spiffy spiffy = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        spiffy.insert(1L, "Tom");
        Iterator<Something> i = spiffy.crashOnFirstRead();
        Assertions.assertThatExceptionOfType(JdbiException.class).isThrownBy(i::next);
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testIteratorClosedIfEmpty() throws Exception {
        Spiffy spiffy = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        spiffy.findAll();
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testIteratorPrepatureClose() throws Exception {
        Spiffy spiffy = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        spiffy.insert(1L, "Tom");
        ResultIterator<Something> all = spiffy.findAll();
        if (all != null) {
            all.close();
        }
        Assertions.assertThat((boolean)this.tracker.hasOpenedHandle()).isFalse();
    }

    @Test
    public void testSqlFromExternalFileWorks() {
        Spiffy spiffy = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        ExternalSql external = (ExternalSql)this.jdbi.onDemand(ExternalSql.class);
        spiffy.insert(1L, "Tom");
        spiffy.insert(2L, "Sam");
        List<Something> all = external.findAll();
        Assertions.assertThat(all).hasSize(2);
    }

    static class HandleTracker
    implements JdbiPlugin {
        final List<Handle> openedHandle = new ArrayList<Handle>();

        HandleTracker() {
        }

        public Handle customizeHandle(Handle handle) {
            this.openedHandle.add(handle);
            return handle;
        }

        boolean hasOpenedHandle() throws SQLException {
            for (Handle h : this.openedHandle) {
                if (h.getConnection().isClosed()) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Spiffy {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlQuery(value="select name, id from something")
        @UseRowMapper(value=SomethingMapper.class)
        public ResultIterator<Something> findAll();

        @SqlQuery(value="select * from crash now")
        @UseRowMapper(value=SomethingMapper.class)
        public Iterator<Something> crashNow();

        @SqlQuery(value="select name, id from something")
        @UseRowMapper(value=CrashingMapper.class)
        public Iterator<Something> crashOnFirstRead();
    }

    @UseClasspathSqlLocator
    public static interface ExternalSql {
        @SqlQuery(value="all-something")
        @UseRowMapper(value=SomethingMapper.class)
        public List<Something> findAll();
    }

    public static class CrashingMapper
    implements RowMapper<Something> {
        public Something map(ResultSet r, StatementContext ctx) throws SQLException {
            throw new SQLException("fake protocol error");
        }
    }

    public static interface TransactionStuff
    extends Transactional<TransactionStuff> {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public Something byId(@Bind(value="id") long var1);

        @SqlUpdate(value="update something set name = :name where id = :id")
        public void updateName(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

