/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.statement.MapTo;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestPolymorphicReturn {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private SheepDao dao;

    @BeforeEach
    public void makeSheep() {
        this.h2Extension.getSharedHandle().execute("insert into something(name, intValue) values('Fluffy', 5)", new Object[0]);
        this.dao = (SheepDao)this.h2Extension.getSharedHandle().attach(SheepDao.class);
    }

    @Test
    public void testPolymorphicReturnSuperclass() {
        Sheep normalSheep = this.dao.get(Sheep.class, "Fluffy");
        Assertions.assertThat((String)normalSheep.getName()).isEqualTo("Fluffy");
    }

    @Test
    public void testPolymorphicReturnSubclass() {
        FlyingSheep flyingSheep = this.dao.get(FlyingSheep.class, "Fluffy");
        Assertions.assertThat((String)flyingSheep.getName()).isEqualTo("Fluffy");
        Assertions.assertThat((int)flyingSheep.getNumWings()).isEqualTo(5);
    }

    @Test
    public void testBadArg() {
        Assertions.assertThatThrownBy(() -> this.dao.getBad("Fluffy is sad :(")).isInstanceOf(UnsupportedOperationException.class);
    }

    @RegisterBeanMapper(value=Sheep.class)
    public static interface SheepDao {
        @RegisterBeanMapper(value=FlyingSheep.class)
        @SqlQuery(value="select name, intValue as numWings from something where name=:name")
        public <T extends Sheep> T get(@MapTo Class<T> var1, String var2);

        @SqlQuery(value="baaaaaa")
        public Sheep getBad(@MapTo String var1);
    }

    public static class Sheep {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class FlyingSheep
    extends Sheep {
        private int numWings;

        public int getNumWings() {
            return this.numWings;
        }

        public void setNumWings(int numWings) {
            this.numWings = numWings;
        }
    }
}

