/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestPositionalBinder {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private SomethingDao somethingDao;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.somethingDao = (SomethingDao)this.handle.attach(SomethingDao.class);
        this.handle.execute("create table something (something_id int primary key, name varchar(100), code int)", new Object[0]);
        this.handle.execute("insert into something(something_id, name, code) values (1, 'Brian', 12)", new Object[0]);
        this.handle.execute("insert into something(something_id, name, code) values (2, 'Keith', 27)", new Object[0]);
        this.handle.execute("insert into something(something_id, name, code) values (3, 'Coda', 14)", new Object[0]);
    }

    @Test
    public void testOnePositionalParameter() {
        String name = this.somethingDao.findNameById(2);
        Assertions.assertThat((String)name).isEqualTo("Keith");
    }

    @Test
    public void testManyPositionalParameters() {
        Integer id = this.somethingDao.getIdByNameAndCode("Coda", 14);
        Assertions.assertThat((Integer)id).isEqualTo(3);
    }

    @Test
    public void testInsertWithPositionalParameters() {
        this.somethingDao.insertSomething(4, "Dave", 90);
        List rows = this.handle.select("select * from something where something_id=?", new Object[]{4}).mapToMap().list();
        Assertions.assertThat((List)rows).containsExactlyElementsOf((Iterable)ImmutableList.of((Object)ImmutableMap.of((Object)"something_id", (Object)4, (Object)"name", (Object)"Dave", (Object)"code", (Object)90)));
    }

    @Test
    public void testInsertWithDefaultParams() {
        this.somethingDao.insertWithDefaultParams("Greg", 21);
        List rows = this.handle.select("select * from something where something_id=?", new Object[]{19}).mapToMap().list();
        Assertions.assertThat((List)rows).containsExactlyElementsOf((Iterable)ImmutableList.of((Object)ImmutableMap.of((Object)"something_id", (Object)19, (Object)"name", (Object)"Greg", (Object)"code", (Object)21)));
    }

    @Test
    public void testInsertWithMixedPositionalAndNamedParams() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.somethingDao.insertWithMixedPositionalAndNamedParams("Jenny", 8675309)).isInstanceOf(UnableToExecuteStatementException.class)).hasMessageContaining("Cannot mix named and positional parameters in a SQL statement");
    }

    public static interface SomethingDao {
        @SqlQuery(value="select name from something where something_id=?")
        public String findNameById(int var1);

        @SqlQuery(value="select something_id from something where name=? and code=?")
        public Integer getIdByNameAndCode(String var1, int var2);

        @SqlUpdate(value="insert into something(something_id, name, code) values (?, ?, ?)")
        public void insertSomething(int var1, String var2, int var3);

        @SqlUpdate(value="insert into something(something_id,name, code) values (19, ?, ?)")
        public void insertWithDefaultParams(String var1, int var2);

        @SqlUpdate(value="insert into something(something_id,name,code) values (19, :name, ?)")
        public void insertWithMixedPositionalAndNamedParams(String var1, int var2);
    }
}

