/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Type;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactories;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestRegisterArgumentFactory {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Jdbi db;

    @BeforeEach
    public void setUp() {
        this.db = this.h2Extension.getJdbi();
    }

    @Test
    public void testSingleAnnotation() {
        this.db.useExtension(Waffle.class, w -> {
            w.insert(1, new Name("Brian", "McCallister"));
            Assertions.assertThat((String)w.findName(1)).isEqualTo("Brian McCallister");
        });
    }

    @Test
    public void testMultipleAnnotations() {
        this.db.useExtension(ShortStack.class, s -> {
            s.insert(1, new Name("George", "Takei"));
            Assertions.assertThat((String)s.findName(1)).isEqualTo("George Takei");
        });
    }

    @RegisterArgumentFactory(value=NameAF.class)
    public static interface Waffle {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") Name var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);
    }

    @RegisterArgumentFactories(value={@RegisterArgumentFactory(value=NameAF.class), @RegisterArgumentFactory(value=LazyAF.class)})
    public static interface ShortStack {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") Name var2);

        @SqlQuery(value="select name from something where id = :id")
        public String findName(@Bind(value="id") int var1);
    }

    public static class Name {
        private final String first;
        private final String last;

        public Name(String first, String last) {
            this.first = first;
            this.last = last;
        }

        public String getFullName() {
            return this.first + " " + this.last;
        }

        public String toString() {
            return "<Name first=" + this.first + " last=" + this.last + " >";
        }
    }

    public static class NameAF
    implements ArgumentFactory {
        public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
            if (expectedType == Name.class || value instanceof Name) {
                Name nameValue = (Name)value;
                return Optional.of((position, statement, ctx1) -> statement.setString(position, nameValue.getFullName()));
            }
            return Optional.empty();
        }
    }

    public static class LazyAF
    implements ArgumentFactory {
        public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
            return Optional.empty();
        }
    }
}

