/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestRegisterConstructorMapper {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.dao = (Dao)this.h2Extension.getSharedHandle().attach(Dao.class);
    }

    @Test
    public void testMapperRegistered() {
        this.dao.insert(1, "brain");
        SubSomething brain = this.dao.getById(1);
        Assertions.assertThat((int)brain.getId()).isOne();
        Assertions.assertThat((String)brain.getName()).isEqualTo("brain");
    }

    @Test
    public void testMapperPrefixed() {
        this.dao.insert(1, "brain");
        SubSomething brain = this.dao.getByIdPrefixed(1);
        Assertions.assertThat((int)brain.getId()).isOne();
        Assertions.assertThat((String)brain.getName()).isEqualTo("brain");
    }

    public static interface Dao {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id=:id")
        @RegisterConstructorMapper(value=SubSomething.class)
        public SubSomething getById(@Bind(value="id") int var1);

        @SqlQuery(value="select id thing_id, name thing_name from something where id=:id")
        @RegisterConstructorMapper(value=SubSomething.class, prefix="thing_")
        public SubSomething getByIdPrefixed(@Bind(value="id") int var1);
    }

    public static class SubSomething
    extends Something {
        public SubSomething(int id, String name) {
            super(id, name);
        }
    }
}

