/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.RowMapperFactory;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.MapWith;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapperFactory;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestRegisterRowMapperFactory {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testSimple() {
        FooDao fooDao = (FooDao)this.h2Extension.getJdbi().onDemand(FooDao.class);
        List<Foo> foos = fooDao.select();
        Assertions.assertThat(foos).isEmpty();
        fooDao.insert(1, "John Doe");
        fooDao.insert(2, "Jane Doe");
        List<Foo> foos2 = fooDao.select();
        Assertions.assertThat(foos2).hasSize(2);
    }

    @RegisterRowMapperFactory(value=MyFactory.class)
    public static interface FooDao {
        @SqlQuery(value="select * from something")
        public List<Foo> select();

        @SqlUpdate(value="insert into something (id, name) VALUES (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);
    }

    @MapWith(value=FooMapper.class)
    public static class Foo {
        private final int id;
        private final String name;

        Foo(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static class FooMapper
        implements RowMapper<Foo> {
            public Foo map(ResultSet r, StatementContext ctx) throws SQLException {
                return new Foo(r.getInt("id"), r.getString("name"));
            }
        }
    }

    public static class MyFactory
    implements RowMapperFactory {
        public Optional<RowMapper<?>> build(Type type, ConfigRegistry config) {
            Class erasedType = GenericTypes.getErasedType((Type)type);
            MapWith mapWith = erasedType.getAnnotation(MapWith.class);
            return mapWith == null ? Optional.empty() : Optional.of((RowMapper)Unchecked.supplier(() -> mapWith.value().getConstructor(new Class[0]).newInstance(new Object[0])).get());
        }
    }
}

