/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestRegisteredMappersWork {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testFoo() {
        boolean worldIsRight = ((BooleanDao)this.h2Extension.getSharedHandle().attach(BooleanDao.class)).fetchABoolean();
        Assertions.assertThat((boolean)worldIsRight).isTrue();
    }

    @Test
    public void testBeanMapperFactory() {
        BeanMappingDao bdb = (BeanMappingDao)this.h2Extension.getSharedHandle().attach(BeanMappingDao.class);
        bdb.createBeanTable();
        Bean lima = new Bean();
        lima.setColor("green");
        lima.setName("lima");
        bdb.insertBean(lima);
        Bean anotherLima = bdb.findByName("lima");
        Assertions.assertThat((String)anotherLima.getName()).isEqualTo(lima.getName());
        Assertions.assertThat((String)anotherLima.getColor()).isEqualTo(lima.getColor());
    }

    @Test
    public void testBeanMapperFactoryDefaultMethod() {
        BeanMappingDao bdb = (BeanMappingDao)this.h2Extension.getSharedHandle().attach(BeanMappingDao.class);
        bdb.createBeanTable();
        Bean lima = new Bean();
        lima.setColor("green");
        lima.setName("lima");
        bdb.insertBean(lima);
        Assertions.assertThat(bdb.findByNameDefaultMethod("lima")).hasValueSatisfying(bean -> Assertions.assertThat((Object)bean).extracting(new Function[]{Bean::getName, Bean::getColor}).contains(new Object[]{lima.getName(), lima.getColor()}));
    }

    @Test
    public void testRegistered() {
        this.h2Extension.getSharedHandle().registerRowMapper((RowMapper)new SomethingMapper());
        Spiffy s = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        s.insert(1L, "Tatu");
        Something t = s.byId(1L);
        Assertions.assertThat((Object)t).isEqualTo((Object)new Something(1, "Tatu"));
    }

    @Test
    public void testBuiltIn() {
        Spiffy s = (Spiffy)this.h2Extension.getSharedHandle().attach(Spiffy.class);
        s.insert(1L, "Tatu");
        Assertions.assertThat((String)s.findNameBy(1L)).isEqualTo("Tatu");
    }

    @Test
    public void testRegisterRowMapperAnnotationWorks() {
        Kabob bob = (Kabob)this.h2Extension.getJdbi().onDemand(Kabob.class);
        bob.insert(1, "Henning");
        Something henning = bob.find(1);
        Assertions.assertThat((Object)henning).isEqualTo((Object)new Something(1, "Henning"));
    }

    @Test
    public void testNoRootRegistrations() {
        try (Handle h = this.h2Extension.openHandle();){
            h.execute("insert into something (id, name) values (1, 'Henning')", new Object[0]);
            Assertions.assertThatThrownBy(() -> h.createQuery("select id, name from something where id = 1").mapTo(Something.class).findFirst()).isInstanceOf(NoSuchMapperException.class);
        }
    }

    @Test
    public void testNoErrorOnNoData() {
        Kabob bob = (Kabob)this.h2Extension.getJdbi().onDemand(Kabob.class);
        Something henning = bob.find(1);
        Assertions.assertThat((Object)henning).isNull();
        List<Something> rs = bob.listAll();
        Assertions.assertThat(rs).isEmpty();
    }

    @Test
    public void testIteratorCloses() {
        Kabob bob = (Kabob)this.h2Extension.getJdbi().onDemand(Kabob.class);
        Iterator<Something> itty = bob.iterateAll();
        Assertions.assertThatThrownBy(itty::hasNext).isInstanceOf(ResultSetException.class);
    }

    public static interface BooleanDao {
        @SqlQuery(value="select 1+1 = 2")
        public boolean fetchABoolean();
    }

    private static interface BeanMappingDao
    extends SqlObject {
        @SqlUpdate(value="create table beans (name varchar primary key, color varchar)")
        public void createBeanTable();

        @SqlUpdate(value="insert into beans (name, color) values (:name, :color)")
        public void insertBean(@BindBean Bean var1);

        @SqlQuery(value="select name, color from beans where name = :name")
        @RegisterBeanMapper(value=Bean.class)
        public Bean findByName(@Bind(value="name") String var1);

        @RegisterBeanMapper(value=Bean.class)
        default public Optional<Bean> findByNameDefaultMethod(String name) {
            return ((Query)this.getHandle().createQuery("select name, color from beans where name = :name").bind("name", name)).mapTo(Bean.class).findFirst();
        }
    }

    public static class Bean {
        private String name;
        private String color;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something byId(@Bind(value="id") long var1);

        @SqlQuery(value="select name from something where id = :id")
        public String findNameBy(@Bind(value="id") long var1);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    @RegisterRowMapper(value=MySomethingMapper.class)
    public static interface Kabob {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        public Something find(@Bind(value="id") int var1);

        @SqlQuery(value="select id, name from something order by id")
        public List<Something> listAll();

        @SqlQuery(value="select id, name from something order by id")
        public Iterator<Something> iterateAll();
    }

    public static class MySomethingMapper
    implements RowMapper<Something> {
        public Something map(ResultSet r, StatementContext ctx) throws SQLException {
            return new Something(r.getInt("id"), r.getString("name"));
        }
    }
}

