/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.sqlobject.config.KeyColumn;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMappers;
import org.jdbi.v3.sqlobject.config.ValueColumn;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestReturningMap {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().installPlugins();
    private Handle h;

    @BeforeEach
    public void setUp() {
        this.h = this.h2Extension.getSharedHandle();
    }

    @Test
    public void keyValueColumns() {
        KeyValueDao dao = (KeyValueDao)this.h.attach(KeyValueDao.class);
        dao.createTable();
        dao.insert("foo", "123");
        dao.insert("bar", "xyz");
        Assertions.assertThat(dao.getAll()).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"123"), Assertions.entry((Object)"bar", (Object)"xyz")});
    }

    @Test
    public void uniqueIndex() {
        UniqueIndexDao dao = (UniqueIndexDao)this.h.attach(UniqueIndexDao.class);
        dao.createTable();
        dao.insert(new User(1, "alice"), new User(2, "bob"), new User(3, "cathy"), new User(4, "dilbert"));
        Assertions.assertThat(dao.getAll()).containsOnly(new Map.Entry[]{Assertions.entry((Object)1, (Object)new User(1, "alice")), Assertions.entry((Object)2, (Object)new User(2, "bob")), Assertions.entry((Object)3, (Object)new User(3, "cathy")), Assertions.entry((Object)4, (Object)new User(4, "dilbert"))});
    }

    @Test
    public void joinRow() {
        JoinRowDao dao = (JoinRowDao)this.h.attach(JoinRowDao.class);
        dao.createUserTable();
        dao.createPhoneTable();
        dao.insertUsers(new User(1, "alice"), new User(2, "bob"), new User(3, "cathy"));
        dao.insertPhone(1, new Phone(10, "555-0001"));
        dao.insertPhone(2, new Phone(20, "555-0002"));
        dao.insertPhone(3, new Phone(30, "555-0003"));
        Assertions.assertThat(dao.getMap()).containsOnly(new Map.Entry[]{Assertions.entry((Object)new User(1, "alice"), (Object)new Phone(10, "555-0001")), Assertions.entry((Object)new User(2, "bob"), (Object)new Phone(20, "555-0002")), Assertions.entry((Object)new User(3, "cathy"), (Object)new Phone(30, "555-0003"))});
    }

    @Test
    public void multimapJoin() {
        JoinRowDao dao = (JoinRowDao)this.h.attach(JoinRowDao.class);
        dao.createUserTable();
        dao.createPhoneTable();
        dao.insertUsers(new User(1, "alice"), new User(2, "bob"), new User(3, "cathy"));
        dao.insertPhone(1, new Phone(10, "555-0001"), new Phone(11, "555-0021"));
        dao.insertPhone(2, new Phone(20, "555-0002"), new Phone(21, "555-0022"));
        dao.insertPhone(3, new Phone(30, "555-0003"), new Phone(31, "555-0023"));
        ImmutableMultimap expected = ImmutableMultimap.builder().putAll((Object)new User(1, "alice"), (Object[])new Phone[]{new Phone(10, "555-0001"), new Phone(11, "555-0021")}).putAll((Object)new User(2, "bob"), (Object[])new Phone[]{new Phone(20, "555-0002"), new Phone(21, "555-0022")}).putAll((Object)new User(3, "cathy"), (Object[])new Phone[]{new Phone(30, "555-0003"), new Phone(31, "555-0023")}).build();
        Assertions.assertThat((Map)dao.getMultimap().asMap()).containsAllEntriesOf((Map)expected.asMap());
    }

    public static interface KeyValueDao {
        @SqlUpdate(value="create table config (\"key\" varchar, \"value\" varchar)")
        public void createTable();

        @SqlUpdate(value="insert into config (\"key\", \"value\") values (:key, :value)")
        public void insert(String var1, String var2);

        @SqlQuery(value="select \"key\", \"value\" from config")
        @KeyColumn(value="key")
        @ValueColumn(value="value")
        public Map<String, String> getAll();
    }

    public static interface UniqueIndexDao {
        @SqlUpdate(value="create table \"user\" (id int, name varchar)")
        public void createTable();

        @SqlBatch(value="insert into \"user\" (id, name) values (:id, :name)")
        public void insert(User ... var1);

        @SqlQuery(value="select * from \"user\"")
        @KeyColumn(value="id")
        @RegisterConstructorMapper(value=User.class)
        public Map<Integer, User> getAll();
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + "'}";
        }
    }

    public static interface JoinRowDao {
        @SqlUpdate(value="create table \"user\" (id int, name varchar)")
        public void createUserTable();

        @SqlUpdate(value="create table phone (id int, user_id int, phone varchar)")
        public void createPhoneTable();

        @SqlBatch(value="insert into \"user\" (id, name) values (:id, :name)")
        public void insertUsers(User ... var1);

        @SqlBatch(value="insert into phone (id, user_id, phone) values (:id, :userId, :phone)")
        public void insertPhone(int var1, Phone ... var2);

        @SqlQuery(value="select u.id u_id, u.name u_name, p.id p_id, p.phone p_phone from \"user\" u left join phone p on u.id = p.user_id")
        @RegisterConstructorMappers(value={@RegisterConstructorMapper(value=User.class, prefix="u"), @RegisterConstructorMapper(value=Phone.class, prefix="p")})
        public Map<User, Phone> getMap();

        @SqlQuery(value="select u.id u_id, u.name u_name, p.id p_id, p.phone p_phone from \"user\" u left join phone p on u.id = p.user_id")
        @RegisterConstructorMappers(value={@RegisterConstructorMapper(value=User.class, prefix="u"), @RegisterConstructorMapper(value=Phone.class, prefix="p")})
        public Multimap<User, Phone> getMultimap();
    }

    public static class Phone {
        private final int id;
        private final String phone;

        public Phone(int id, String phone) {
            this.id = id;
            this.phone = phone;
        }

        public int getId() {
            return this.id;
        }

        public String getPhone() {
            return this.phone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Phone phone1 = (Phone)o;
            return this.id == phone1.id && Objects.equals(this.phone, phone1.phone);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.phone);
        }

        public String toString() {
            return "Phone{id=" + this.id + ", phone='" + this.phone + "'}";
        }
    }
}

