/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultIterable;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestReturningQuery {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testWithRegisteredMapper() {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.h2Extension.getJdbi().useExtension(Spiffy.class, spiffy -> {
            Something s = (Something)spiffy.findById(7).one();
            Assertions.assertThat((String)s.getName()).isEqualTo("Tim");
        });
    }

    @Test
    public void testWithExplicitMapper() {
        this.handle.execute("insert into something (id, name) values (7, 'Tim')", new Object[0]);
        this.h2Extension.getJdbi().useExtension(Spiffy2.class, spiffy -> {
            Something s = (Something)spiffy.findByIdWithExplicitMapper(7).one();
            Assertions.assertThat((String)s.getName()).isEqualTo("Tim");
        });
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlQuery(value="select id, name from something where id = :id")
        public ResultIterable<Something> findById(@Bind(value="id") int var1);
    }

    public static interface Spiffy2 {
        @SqlQuery(value="select id, name from something where id = :id")
        @UseRowMapper(value=SomethingMapper.class)
        public ResultIterable<Something> findByIdWithExplicitMapper(@Bind(value="id") int var1);
    }
}

