/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestStatements {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());

    @Test
    public void testInsert() {
        this.h2Extension.getJdbi().useExtension(Inserter.class, i -> {
            int rowsAffected = i.insert(2L, "Diego");
            String name = (String)this.h2Extension.getSharedHandle().createQuery("select name from something where id = 2").mapTo(String.class).one();
            Assertions.assertThat((int)rowsAffected).isOne();
            Assertions.assertThat((String)name).isEqualTo("Diego");
        });
    }

    @Test
    public void testInsertWithVoidReturn() {
        this.h2Extension.getJdbi().useExtension(Inserter.class, i -> {
            i.insertWithVoidReturn(2L, "Diego");
            String name = (String)this.h2Extension.getSharedHandle().createQuery("select name from something where id = 2").mapTo(String.class).one();
            Assertions.assertThat((String)name).isEqualTo("Diego");
        });
    }

    @Test
    public void testDoubleArgumentBind() {
        this.h2Extension.getJdbi().useExtension(Doubler.class, d -> Assertions.assertThat((boolean)d.doubleTest("wooooot")).isTrue());
    }

    public static interface Inserter {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertWithVoidReturn(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }

    public static interface Doubler {
        @SqlQuery(value="select :test = :test")
        public boolean doubleTest(@Bind(value="test") String var1);
    }
}

