/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.h2.jdbc.JdbcSQLNonTransientException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.statement.UseRowMapper;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class TestStream {
    static final Something ONE = new Something(3, "foo");
    static final Something TWO = new Something(4, "bar");
    static final Something THREE = new Something(5, "baz");
    @RegisterExtension
    JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    Handle handle;
    Jdbi jdbi;

    TestStream() {
    }

    @BeforeEach
    void setUp() {
        this.jdbi = this.h2Extension.getJdbi();
        this.handle = this.h2Extension.getSharedHandle();
        this.insert(ONE);
        this.insert(TWO);
        this.insert(THREE);
    }

    private void insert(Something something) {
        try (Update update = this.handle.createUpdate("INSERT INTO something (id, name) VALUES (:id, :name)");){
            ((Update)update.bindBean((Object)something)).execute();
        }
    }

    private void assertResourcesClosed(ThrowableAssert.ThrowingCallable callable) {
        ((ThrowableAssertAlternative)Assertions.assertThatExceptionOfType(ResultSetException.class).isThrownBy(callable).withMessageContaining("Unable to advance result set").havingCause().isInstanceOf(JdbcSQLNonTransientException.class)).hasFieldOrPropertyWithValue("errorCode", (Object)90007);
    }

    @Test
    void testAttachStreamExhaust() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        try (Stream<Something> stream = dao.stream();){
            Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        }
    }

    @Test
    void testAttachStreamSneaky() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        try (Stream<Something> stream = dao.sneakyStream();){
            Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
        }
    }

    @Test
    void testAttachStreamLeak() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        Stream<Something> stream = dao.stream();
        ((OptionalAssert)Assertions.assertThat(stream.findFirst()).isPresent()).contains((Object)THREE);
    }

    @Test
    void testAttachStreamCallbackExhaust() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        dao.stream(stream -> Assertions.assertThat((Stream)stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE}));
    }

    @Test
    void testAttachStreamCallbackLeak() {
        Spiffy dao = (Spiffy)this.handle.attach(Spiffy.class);
        dao.stream(stream -> ((OptionalAssert)Assertions.assertThat(stream.findFirst()).isPresent()).contains((Object)THREE));
    }

    @Test
    void testOnDemandStreamExhaustFails() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        this.assertResourcesClosed(() -> {
            try (Stream<Something> stream = dao.stream();){
                Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testOnDemandStreamSneakyFails() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        this.assertResourcesClosed(() -> {
            try (Stream<Something> stream = dao.sneakyStream();){
                Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testOnDemandStreamWrapped() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.streamTester();
    }

    @Test
    void testOnDemandStreamWrappedLeak() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.streamLeakTester();
    }

    @Test
    void testOnDemandStreamCallbackExhaust() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.stream(stream -> Assertions.assertThat((Stream)stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE}));
    }

    @Test
    void testOnDemandStreamCallbackLeak() {
        Spiffy dao = (Spiffy)this.jdbi.onDemand(Spiffy.class);
        dao.stream(stream -> ((OptionalAssert)Assertions.assertThat(stream.findFirst()).isPresent()).contains((Object)THREE));
    }

    @Test
    void testExtensionStreamExhaust() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            try (Stream<Something> stream = dao.stream();){
                Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testExtensionStreamSneaky() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            try (Stream<Something> stream = dao.sneakyStream();){
                Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    @Test
    void testExtensionStreamLeak() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            Stream<Something> stream = dao.stream();
            ((OptionalAssert)Assertions.assertThat(stream.findFirst()).isPresent()).contains((Object)THREE);
        });
    }

    @Test
    void testExtensionStreamCallbackExhaust() {
        this.jdbi.useExtension(Spiffy.class, dao -> dao.stream(stream -> Assertions.assertThat((Stream)stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE})));
    }

    @Test
    void testExtensionStreamCallbackLeak() {
        this.jdbi.useExtension(Spiffy.class, dao -> {
            Stream<Something> stream = dao.stream();
            ((OptionalAssert)Assertions.assertThat(stream.findFirst()).isPresent()).contains((Object)THREE);
        });
    }

    @Test
    void testExtensionStreamReturnFails() {
        this.assertResourcesClosed(() -> {
            try (Stream stream = (Stream)this.jdbi.withExtension(Spiffy.class, Spiffy::stream);){
                Assertions.assertThat((Stream)stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        });
    }

    public static interface Spiffy {
        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public Stream<Something> stream();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something order by id desc")
        @UseRowMapper(value=SomethingMapper.class)
        public void stream(Consumer<Stream<Something>> var1);

        default public void streamTester() {
            try (Stream<Something> stream = this.stream();){
                Assertions.assertThat(stream).containsExactly((Object[])new Something[]{THREE, TWO, ONE});
            }
        }

        default public void streamLeakTester() {
            Stream<Something> stream = this.stream();
            ((OptionalAssert)Assertions.assertThat(stream.findFirst()).isPresent()).contains((Object)THREE);
        }

        default public Stream<Something> sneakyStream() {
            return this.stream();
        }
    }
}

