/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.result.NoResultsException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.locator.UseClasspathSqlLocator;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestUseClasspathSqlLocator {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.execute("insert into something (id, name) values (6, 'Martin')", new Object[0]);
    }

    @Test
    public void testBam() {
        Something s = ((Cromulence)this.handle.attach(Cromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo("Martin");
    }

    @Test
    public void testOverride() {
        Something s = ((SubCromulence)this.handle.attach(SubCromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo("overridden");
    }

    @Test
    public void testCachedOverride() {
        Something s = ((Cromulence)this.handle.attach(Cromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo("Martin");
        s = ((SubCromulence)this.handle.attach(SubCromulence.class)).findById(6L);
        Assertions.assertThat((String)s.getName()).isEqualTo("overridden");
    }

    @Test
    public void emptyFileYieldsEmptyString() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(((Blanks)this.handle.attach(Blanks.class))::methodWithEmptyFile).describedAs("empty string used as query", new Object[0])).isInstanceOf(NoResultsException.class)).hasMessageContaining("Statement returned no results").hasMessageContaining("statement:\"\"");
    }

    @Test
    public void missingFileThrows() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(((Blanks)this.handle.attach(Blanks.class))::methodWithoutFile).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Cannot find classpath resource").hasMessageContaining("methodWithoutFile.sql");
    }

    @UseClasspathSqlLocator
    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Cromulence {
        @SqlQuery
        public Something findById(@Bind(value="id") Long var1);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    @UseClasspathSqlLocator
    public static interface SubCromulence
    extends Cromulence {
    }

    @UseClasspathSqlLocator
    public static interface Blanks {
        @SqlQuery(value="empty")
        public String methodWithEmptyFile();

        @SqlQuery
        public String methodWithoutFile();
    }
}

