/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;
import org.jdbi.v3.sqlobject.config.Comment;

public class Article {
    private long id;
    private String title;
    private String content;
    private List<Comment> comments = new ArrayList<Comment>();

    public static Article newArticle(long id, String title) {
        return Article.newArticle(id, title, null, new Comment[0]);
    }

    public static Article newArticle(long id, String title, String content, Comment ... comments) {
        Article article = new Article(id, title, content);
        article.getComments().addAll(Arrays.asList(comments));
        return article;
    }

    public Article() {
    }

    @JdbiConstructor
    public Article(long id, String title, String content) {
        this.setId(id);
        this.setTitle(title);
        this.setContent(content);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Article article = (Article)o;
        return this.id == article.id && Objects.equals(this.title, article.title) && Objects.equals(this.content, article.content) && Objects.equals(this.comments, article.comments);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.content, this.comments);
    }

    public String toString() {
        return "Article{id=" + this.id + ", title='" + this.title + "', content='" + this.content + "', comments=" + String.valueOf(this.comments) + "}";
    }
}

