/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.AllowUnusedBindings;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestAllowUnusedBindings {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private UnusedBindingDao dao;

    @BeforeEach
    public void setUp() {
        this.dao = (UnusedBindingDao)this.h2Extension.getJdbi().onDemand(UnusedBindingDao.class);
    }

    @Test
    public void testAllowed() {
        Assertions.assertThat((boolean)this.dao.allowed("42")).isTrue();
    }

    @Test
    public void testDisallowed() {
        ((SqlStatements)this.dao.getHandle().getConfig(SqlStatements.class)).setUnusedBindingAllowed(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.dao.disallowed("43")).isInstanceOf(UnableToCreateStatementException.class)).hasMessageContaining("named parameter");
    }

    @Test
    public void testUnannotated() {
        ((SqlStatements)this.h2Extension.getJdbi().getConfig(SqlStatements.class)).setUnusedBindingAllowed(true);
        Assertions.assertThat((boolean)this.dao.unannotated("42")).isTrue();
    }

    static interface UnusedBindingDao
    extends SqlObject {
        @SqlQuery(value="select true")
        @AllowUnusedBindings
        public boolean allowed(String var1);

        @SqlQuery(value="select true")
        @AllowUnusedBindings(value=false)
        public boolean disallowed(String var1);

        @SqlQuery(value="select true")
        public boolean unannotated(String var1);
    }
}

