/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.h2.H2DatabasePlugin;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SingleValue;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.statement.BatchChunkSize;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBatchingSingleValue {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new H2DatabasePlugin());
    private Handle handle;
    private SingleValueBatching b;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.execute("create table batching (id integer, vals integer array)", new Object[0]);
        this.b = (SingleValueBatching)this.handle.attach(SingleValueBatching.class);
    }

    @Test
    public void testSingleValueArray() {
        int[] ids = IntStream.range(0, 10).toArray();
        int[] values = IntStream.range(50, 60).toArray();
        this.b.insertValues(ids, values);
        Assertions.assertThat(this.b.select()).containsExactly((Object[])((BatchingRow[])Arrays.stream(ids).mapToObj(id -> new BatchingRow(id, values)).toArray(BatchingRow[]::new)));
    }

    @BatchChunkSize(value=4)
    @RegisterConstructorMapper(value=BatchingRow.class)
    public static interface SingleValueBatching {
        @SqlBatch(value="insert into batching (id, vals) values (:id, :vals)")
        public int[] insertValues(int[] var1, @SingleValue int[] var2);

        @SqlQuery(value="select id, vals from batching order by id asc")
        public List<BatchingRow> select();
    }

    public static class BatchingRow {
        final int id;
        final int[] vals;

        public BatchingRow(int id, int[] vals) {
            this.id = id;
            this.vals = vals;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BatchingRow) {
                BatchingRow other = (BatchingRow)obj;
                return this.id == other.id && Arrays.equals(this.vals, other.vals);
            }
            return false;
        }

        public int hashCode() {
            return this.id ^ Arrays.hashCode(this.vals);
        }

        public String toString() {
            return String.format("%s %s", this.id, Arrays.toString(this.vals));
        }
    }
}

