/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.subpackage.PrivateImplementationFactory;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBeanBinder {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
    }

    @Test
    public void testInsert() {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        s.insert(new Something(2, "Bean"));
        String name = (String)this.handle.createQuery("select name from something where id = 2").mapTo(String.class).one();
        Assertions.assertThat((String)name).isEqualTo("Bean");
    }

    @Test
    public void testRead() {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        this.handle.execute("insert into something (id, name) values (17, 'Phil')", new Object[0]);
        Something phil = s.findByEqualsOnBothFields(new Something(17, "Phil"));
        Assertions.assertThat((String)phil.getName()).isEqualTo("Phil");
    }

    @Test
    public void testBindingPrivateTypeUsingPublicInterface() {
        Spiffy s = (Spiffy)this.handle.attach(Spiffy.class);
        Assertions.assertThat((String)s.selectPublicInterfaceValue(PrivateImplementationFactory.create())).isEqualTo("IShouldBind");
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface Spiffy {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@BindBean Something var1);

        @SqlQuery(value="select id, name from something where id = :s.id and name = :s.name")
        public Something findByEqualsOnBothFields(@BindBean(value="s") Something var1);

        @SqlQuery(value="select :pi.value")
        public String selectPublicInterfaceValue(@BindBean(value="pi") PublicInterface var1);
    }

    public static interface PublicInterface {
        public String getValue();
    }
}

