/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.ValueType;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ValueTypeMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestBindBean {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;
    private Dao dao;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.dao = (Dao)this.handle.attach(Dao.class);
    }

    @Test
    public void testBindBean() {
        this.handle.execute("insert into something (id, name) values (1, 'Alice')", new Object[0]);
        Assertions.assertThat((String)this.dao.getName(1L)).isEqualTo("Alice");
        this.dao.update(new Something(1, "Alicia"));
        Assertions.assertThat((String)this.dao.getName(1L)).isEqualTo("Alicia");
    }

    @Test
    public void testBindBeanPrefix() {
        this.handle.execute("insert into something (id, name) values (2, 'Bob')", new Object[0]);
        Assertions.assertThat((String)this.dao.getName(2L)).isEqualTo("Bob");
        this.dao.updatePrefix(new Something(2, "Rob"));
        Assertions.assertThat((String)this.dao.getName(2L)).isEqualTo("Rob");
    }

    @Test
    public void testNoArgumentFactoryRegisteredForProperty() {
        this.handle.execute("create table beans (id integer, value_type varchar)", new Object[0]);
        Assertions.assertThatThrownBy(() -> ((BeanDao)this.handle.attach(BeanDao.class)).insert(new Bean(1, ValueType.valueOf((String)"foo")))).hasMessageContaining("No argument factory registered");
    }

    @Test
    public void testArgumentFactoryRegisteredForProperty() {
        this.handle.execute("create table beans (id integer, value_type varchar, fromField varchar, fromGetter varchar)", new Object[0]);
        this.handle.registerArgument((ArgumentFactory)new ValueTypeArgumentFactory());
        BeanDao beanDao = (BeanDao)this.handle.attach(BeanDao.class);
        beanDao.insert(new Bean(1, ValueType.valueOf((String)"foo")));
        Assertions.assertThat((Object)beanDao.getById(1)).extracting(new Function[]{Bean::getId, Bean::getValueType}).containsExactly(new Object[]{1, ValueType.valueOf((String)"foo")});
    }

    public static interface Dao {
        @SqlUpdate(value="update something set name=:name where id=:id")
        public void update(@BindBean Something var1);

        @SqlUpdate(value="update something set name=:thing.name where id=:thing.id")
        public void updatePrefix(@BindBean(value="thing") Something var1);

        @SqlQuery(value="select name from something where id = :id")
        public String getName(long var1);
    }

    public static class ValueTypeArgumentFactory
    extends AbstractArgumentFactory<ValueType> {
        public ValueTypeArgumentFactory() {
            super(12);
        }

        protected Argument build(ValueType value, ConfigRegistry config) {
            return (pos, stmt, ctx) -> stmt.setString(pos, value.getValue());
        }
    }

    public static interface BeanDao {
        @SqlUpdate(value="insert into beans (id, value_type) values (:id, :valueType)")
        public void insert(@BindBean Bean var1);

        @SqlQuery(value="select * from beans where id = :id")
        @RegisterConstructorMapper(value=Bean.class)
        @RegisterColumnMapper(value=ValueTypeMapper.class)
        public Bean getById(int var1);
    }

    public static class Bean {
        private int id;
        private ValueType valueType;

        public Bean(int id, ValueType valueType) {
            this.id = id;
            this.valueType = valueType;
        }

        public int getId() {
            return this.id;
        }

        public ValueType getValueType() {
            return this.valueType;
        }

        public int getWithParameterIsIgnored(int param) {
            return param;
        }
    }
}

