/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBindListParameter {
    private Jdbi db;
    private Handle handle;
    private MyDAO dao;

    @BeforeEach
    public void setUp() {
        this.db = Jdbi.create((String)("jdbc:h2:mem:" + String.valueOf(UUID.randomUUID())));
        this.db.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        this.handle = this.db.open();
        this.handle.createUpdate("create table foo (id int, bar varchar(100) default null);").execute();
        this.dao = (MyDAO)this.db.onDemand(MyDAO.class);
    }

    @AfterEach
    public void tearDown() {
        this.handle.execute("drop table foo", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testBrokenSyntax() {
        Assertions.assertThatThrownBy(this.dao::broken).isInstanceOf(UnableToCreateStatementException.class);
    }

    @Test
    public void testWorks() {
        int result = this.dao.works(Lists.newArrayList((Object[])new Long[]{1L, 2L}));
        Assertions.assertThat((int)result).isZero();
    }

    @Test
    public void testIds() {
        int result = this.dao.ids(Lists.newArrayList((Object[])new Integer[]{1, 2}));
        Assertions.assertThat((int)result).isZero();
    }

    private static interface MyDAO {
        @SqlQuery(value="select count(*) from foo where bar < 12 and id in (<ids>)")
        public int broken();

        @SqlQuery(value="select count(*) from foo where bar \\< 12 and id in (<ids>)")
        public int works(@BindList List<Long> var1);

        @SqlQuery(value="select count(*) from foo where id in (<ids>)")
        public int ids(@BindList List<Integer> var1);
    }
}

