/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.CreateSqlObject;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.UnableToCreateSqlObjectException;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.jdbi.v3.testing.junit5.internal.TestingInitializers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestCreateSqlObjectAnnotation {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withInitializer(TestingInitializers.something()).withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.h2Extension.getJdbi().registerRowMapper((RowMapper)new SomethingMapper());
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.registerRowMapper((RowMapper)new SomethingMapper());
    }

    @Test
    public void testSimpleCreate() {
        Foo foo = (Foo)this.handle.attach(Foo.class);
        foo.insert(1, "Stephane");
        Something s = foo.createBar().findById(1);
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Stephane"));
    }

    @Test
    public void testInsertAndFind() {
        Foo foo = (Foo)this.handle.attach(Foo.class);
        Something s = foo.insertAndFind(1, "Stephane");
        Assertions.assertThat((Object)s).isEqualTo((Object)new Something(1, "Stephane"));
    }

    @Test
    public void testTransactionPropagates() {
        Foo foo = (Foo)this.h2Extension.getSharedHandle().attach(Foo.class);
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> foo.insertAndFail(1, "Jeff"));
        Something n = foo.createBar().findById(1);
        Assertions.assertThat((Object)n).isNull();
    }

    @Test
    public void subObjectIsSqlObject() throws Exception {
        Assertions.assertThat((Object)((Bar)this.h2Extension.getJdbi().withExtension(Foo.class, Foo::createBar))).isInstanceOf(SqlObject.class);
    }

    @Test
    public void testMeaningfulExceptionWhenWrongReturnTypeOfSqlUpdate() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(BogusSqlUpdateDao.class)).isInstanceOf(UnableToCreateSqlObjectException.class)).hasMessage("BogusSqlUpdateDao.getNames method is annotated with @SqlUpdate so should return void, boolean, or Number but is returning: java.util.List<java.lang.String>");
    }

    @Test
    public void testMeaningfulExceptionWhenWrongReturnTypeOfSqlBatch() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.h2Extension.getSharedHandle().attach(BogusSqlBatchDao.class)).isInstanceOf(UnableToCreateSqlObjectException.class)).hasMessageContaining("BogusSqlBatchDao.getNames method is annotated with @SqlBatch so should return void, int[], or boolean[] but is returning: int");
    }

    public static interface Foo {
        @CreateSqlObject
        public Bar createBar();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @Transaction
        default public Something insertAndFind(int id, String name) {
            this.insert(id, name);
            return this.createBar().findById(id);
        }

        @Transaction
        default public Something insertAndFail(int id, String name) {
            this.insert(id, name);
            return this.createBar().explode();
        }
    }

    public static interface Bar {
        @SqlQuery(value="select id, name from something where id = :id")
        public Something findById(@Bind(value="id") int var1);

        default public Something explode() {
            throw new RuntimeException();
        }
    }

    public static interface BogusSqlBatchDao {
        @SqlBatch(value="insert into table (a) values (:a)")
        public int getNames(@Bind(value="a") String var1);
    }

    public static interface BogusSqlUpdateDao {
        @SqlUpdate(value="select name from something")
        public List<String> getNames();
    }
}

