/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.mapper.SomethingMapper;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.BindList;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.customizer.DefineList;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.junit5.JdbiExtension;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestDefineListParameter {
    @RegisterExtension
    public JdbiExtension h2Extension = JdbiExtension.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin());
    private final String[] columnsArray = new String[]{"id", "name"};
    private final List<String> testColumns = Arrays.asList(this.columnsArray);
    private Handle handle;

    @BeforeEach
    public void setUp() {
        this.handle = this.h2Extension.getSharedHandle();
        this.handle.execute("create table test (id identity primary key, name varchar(50))", new Object[0]);
        this.handle.execute("create table testNullable (id identity primary key, name varchar(50) null)", new Object[0]);
    }

    @Test
    public void testWithBindList() {
        TestDao testDao = (TestDao)this.handle.attach(TestDao.class);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(1);
        values.add("Some Pig");
        ArrayList<Object> valuesNull = new ArrayList<Object>();
        valuesNull.add(2);
        valuesNull.add(null);
        testDao.insert("test", this.testColumns, values);
        testDao.insert("testNullable", this.testColumns, valuesNull);
        Something something = new Something(1, "Some Pig");
        Something nothing = new Something(2, null);
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 1L)).isEqualTo((Object)something);
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "testNullable", 1L)).isNull();
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 2L)).isNull();
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "testNullable", 2L)).isEqualTo((Object)nothing);
    }

    @Test
    public void testWithBindBean() {
        TestDao testDao = (TestDao)this.handle.attach(TestDao.class);
        Something something = new Something(1, "Some Pig");
        Something nothing = new Something(2, null);
        testDao.insert("test", this.testColumns, something);
        testDao.insert("testNullable", this.testColumns, nothing);
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 1L)).isEqualTo((Object)something);
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "testNullable", 1L)).isNull();
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 2L)).isNull();
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "testNullable", 2L)).isEqualTo((Object)nothing);
    }

    @Test
    public void testArray() {
        TestDao testDao = (TestDao)this.handle.attach(TestDao.class);
        testDao.insert("test", this.columnsArray, (List<Object>)ImmutableList.of((Object)1, (Object)"Some Pig"));
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 1L)).isEqualTo((Object)new Something(1, "Some Pig"));
    }

    @Test
    public void nullHostileContains() {
        TestDao testDao = (TestDao)this.handle.attach(TestDao.class);
        AbstractList<String> columns = new AbstractList<String>(){

            @Override
            public int size() {
                return TestDefineListParameter.this.testColumns.size();
            }

            @Override
            public String get(int index) {
                return TestDefineListParameter.this.testColumns.get(index);
            }

            @Override
            public boolean contains(Object o) {
                if (o == null) {
                    throw new NullPointerException();
                }
                return TestDefineListParameter.this.testColumns.contains(o);
            }
        };
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(1);
        values.add("Some Pig");
        testDao.insert("test", (List<String>)columns, values);
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 1L)).isEqualTo((Object)new Something(1, "Some Pig"));
    }

    @Test
    public void testDefaultedNameInsert() {
        TestDao testDao = (TestDao)this.handle.attach(TestDao.class);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(1);
        values.add("Some Pig");
        testDao.defaultedInsert("test", this.testColumns, values);
        Assertions.assertThat((Object)testDao.findById(this.testColumns, "test", 1L)).isEqualTo((Object)new Something(1, "Some Pig"));
    }

    @Test
    public void testEmptyList() {
        TestDao testDao = (TestDao)this.handle.attach(TestDao.class);
        ArrayList noColumns = new ArrayList();
        Something something = new Something(1, "Some Pig");
        Assertions.assertThatThrownBy(() -> testDao.insert("test", (List<String>)noColumns, something)).isInstanceOf(IllegalArgumentException.class);
    }

    @RegisterRowMapper(value=SomethingMapper.class)
    public static interface TestDao {
        @SqlUpdate(value="insert into <table> (<columns>) values (<values>)")
        public void insert(@Define(value="table") String var1, @DefineList(value="columns") List<String> var2, @BindList List<Object> var3);

        @SqlUpdate(value="insert into <table> (<columns>) values (:id, :name)")
        public void insert(@Define(value="table") String var1, @DefineList(value="columns") List<String> var2, @BindBean Something var3);

        @SqlUpdate(value="insert into <table> (<columns>) values (<values>)")
        public void insert(@Define(value="table") String var1, @DefineList(value="columns") Object[] var2, @BindList List<Object> var3);

        @SqlUpdate(value="insert into <table> (<columns>) values (<values>)")
        public void defaultedInsert(@Define(value="table") String var1, @DefineList List<String> var2, @BindList List<Object> var3);

        @SqlQuery(value="select <columns> from <table> where id = :id")
        public Something findById(@DefineList(value="columns") List<String> var1, @Define(value="table") String var2, @Bind(value="id") long var3);
    }
}

